/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.StepState;
import software.amazon.awssdk.services.emr.model.StepStateListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStepsRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, ListStepsRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(ListStepsRequest.getter(ListStepsRequest::clusterId)).setter(ListStepsRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<List<String>> STEP_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepStates").getter(ListStepsRequest.getter(ListStepsRequest::stepStatesAsStrings)).setter(ListStepsRequest.setter(Builder::stepStatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STEP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepIds").getter(ListStepsRequest.getter(ListStepsRequest::stepIds)).setter(ListStepsRequest.setter(Builder::stepIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListStepsRequest.getter(ListStepsRequest::marker)).setter(ListStepsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, STEP_STATES_FIELD, STEP_IDS_FIELD, MARKER_FIELD));
    private final String clusterId;
    private final List<String> stepStates;
    private final List<String> stepIds;
    private final String marker;

    private ListStepsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.stepStates = builder.stepStates;
        this.stepIds = builder.stepIds;
        this.marker = builder.marker;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final List<StepState> stepStates() {
        return StepStateListCopier.copyStringToEnum(this.stepStates);
    }

    public final boolean hasStepStates() {
        return this.stepStates != null && !(this.stepStates instanceof SdkAutoConstructList);
    }

    public final List<String> stepStatesAsStrings() {
        return this.stepStates;
    }

    public final boolean hasStepIds() {
        return this.stepIds != null && !(this.stepIds instanceof SdkAutoConstructList);
    }

    public final List<String> stepIds() {
        return this.stepIds;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepStates() ? this.stepStatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepIds() ? this.stepIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsRequest)) {
            return false;
        }
        ListStepsRequest other = (ListStepsRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && this.hasStepStates() == other.hasStepStates() && Objects.equals(this.stepStatesAsStrings(), other.stepStatesAsStrings()) && this.hasStepIds() == other.hasStepIds() && Objects.equals(this.stepIds(), other.stepIds()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListStepsRequest").add("ClusterId", (Object)this.clusterId()).add("StepStates", this.hasStepStates() ? this.stepStatesAsStrings() : null).add("StepIds", this.hasStepIds() ? this.stepIds() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "StepStates": {
                return Optional.ofNullable(clazz.cast(this.stepStatesAsStrings()));
            }
            case "StepIds": {
                return Optional.ofNullable(clazz.cast(this.stepIds()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStepsRequest, T> g) {
        return obj -> g.apply((ListStepsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private List<String> stepStates = DefaultSdkAutoConstructList.getInstance();
        private List<String> stepIds = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStepsRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.stepStatesWithStrings(model.stepStates);
            this.stepIds(model.stepIds);
            this.marker(model.marker);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<String> getStepStates() {
            if (this.stepStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepStates;
        }

        @Override
        public final Builder stepStatesWithStrings(Collection<String> stepStates) {
            this.stepStates = StepStateListCopier.copy(stepStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStatesWithStrings(String ... stepStates) {
            this.stepStatesWithStrings(Arrays.asList(stepStates));
            return this;
        }

        @Override
        public final Builder stepStates(Collection<StepState> stepStates) {
            this.stepStates = StepStateListCopier.copyEnumToString(stepStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(StepState ... stepStates) {
            this.stepStates(Arrays.asList(stepStates));
            return this;
        }

        public final void setStepStates(Collection<String> stepStates) {
            this.stepStates = StepStateListCopier.copy(stepStates);
        }

        public final Collection<String> getStepIds() {
            if (this.stepIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = XmlStringListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String ... stepIds) {
            this.stepIds(Arrays.asList(stepIds));
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = XmlStringListCopier.copy(stepIds);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStepsRequest build() {
            return new ListStepsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStepsRequest> {
        public Builder clusterId(String var1);

        public Builder stepStatesWithStrings(Collection<String> var1);

        public Builder stepStatesWithStrings(String ... var1);

        public Builder stepStates(Collection<StepState> var1);

        public Builder stepStates(StepState ... var1);

        public Builder stepIds(Collection<String> var1);

        public Builder stepIds(String ... var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

