/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AlpnPolicyNameCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Listener
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Listener> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ListenerArn").getter(Listener.getter(Listener::listenerArn)).setter(Listener.setter(Builder::listenerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()}).build();
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerArn").getter(Listener.getter(Listener::loadBalancerArn)).setter(Listener.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(Listener.getter(Listener::port)).setter(Listener.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(Listener.getter(Listener::protocolAsString)).setter(Listener.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<List<Certificate>> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Certificates").getter(Listener.getter(Listener::certificates)).setter(Listener.setter(Builder::certificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SSL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslPolicy").getter(Listener.getter(Listener::sslPolicy)).setter(Listener.setter(Builder::sslPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslPolicy").build()}).build();
    private static final SdkField<List<Action>> DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultActions").getter(Listener.getter(Listener::defaultActions)).setter(Listener.setter(Builder::defaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALPN_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlpnPolicy").getter(Listener.getter(Listener::alpnPolicy)).setter(Listener.setter(Builder::alpnPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlpnPolicy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD, LOAD_BALANCER_ARN_FIELD, PORT_FIELD, PROTOCOL_FIELD, CERTIFICATES_FIELD, SSL_POLICY_FIELD, DEFAULT_ACTIONS_FIELD, ALPN_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String listenerArn;
    private final String loadBalancerArn;
    private final Integer port;
    private final String protocol;
    private final List<Certificate> certificates;
    private final String sslPolicy;
    private final List<Action> defaultActions;
    private final List<String> alpnPolicy;

    private Listener(BuilderImpl builder) {
        this.listenerArn = builder.listenerArn;
        this.loadBalancerArn = builder.loadBalancerArn;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.certificates = builder.certificates;
        this.sslPolicy = builder.sslPolicy;
        this.defaultActions = builder.defaultActions;
        this.alpnPolicy = builder.alpnPolicy;
    }

    public final String listenerArn() {
        return this.listenerArn;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final Integer port() {
        return this.port;
    }

    public final ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final boolean hasCertificates() {
        return this.certificates != null && !(this.certificates instanceof SdkAutoConstructList);
    }

    public final List<Certificate> certificates() {
        return this.certificates;
    }

    public final String sslPolicy() {
        return this.sslPolicy;
    }

    public final boolean hasDefaultActions() {
        return this.defaultActions != null && !(this.defaultActions instanceof SdkAutoConstructList);
    }

    public final List<Action> defaultActions() {
        return this.defaultActions;
    }

    public final boolean hasAlpnPolicy() {
        return this.alpnPolicy != null && !(this.alpnPolicy instanceof SdkAutoConstructList);
    }

    public final List<String> alpnPolicy() {
        return this.alpnPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificates() ? this.certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sslPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultActions() ? this.defaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlpnPolicy() ? this.alpnPolicy() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        return Objects.equals(this.listenerArn(), other.listenerArn()) && Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasCertificates() == other.hasCertificates() && Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.sslPolicy(), other.sslPolicy()) && this.hasDefaultActions() == other.hasDefaultActions() && Objects.equals(this.defaultActions(), other.defaultActions()) && this.hasAlpnPolicy() == other.hasAlpnPolicy() && Objects.equals(this.alpnPolicy(), other.alpnPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"Listener").add("ListenerArn", (Object)this.listenerArn()).add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("Certificates", this.hasCertificates() ? this.certificates() : null).add("SslPolicy", (Object)this.sslPolicy()).add("DefaultActions", this.hasDefaultActions() ? this.defaultActions() : null).add("AlpnPolicy", this.hasAlpnPolicy() ? this.alpnPolicy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListenerArn": {
                return Optional.ofNullable(clazz.cast(this.listenerArn()));
            }
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "SslPolicy": {
                return Optional.ofNullable(clazz.cast(this.sslPolicy()));
            }
            case "DefaultActions": {
                return Optional.ofNullable(clazz.cast(this.defaultActions()));
            }
            case "AlpnPolicy": {
                return Optional.ofNullable(clazz.cast(this.alpnPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Listener, T> g) {
        return obj -> g.apply((Listener)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String listenerArn;
        private String loadBalancerArn;
        private Integer port;
        private String protocol;
        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();
        private String sslPolicy;
        private List<Action> defaultActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> alpnPolicy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            this.listenerArn(model.listenerArn);
            this.loadBalancerArn(model.loadBalancerArn);
            this.port(model.port);
            this.protocol(model.protocol);
            this.certificates(model.certificates);
            this.sslPolicy(model.sslPolicy);
            this.defaultActions(model.defaultActions);
            this.alpnPolicy(model.alpnPolicy);
        }

        public final String getListenerArn() {
            return this.listenerArn;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final List<Certificate.Builder> getCertificates() {
            List<Certificate.Builder> result = CertificateListCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificateListCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (Certificate)((Certificate.Builder)Certificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSslPolicy() {
            return this.sslPolicy;
        }

        public final void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        @Override
        public final Builder sslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public final List<Action.Builder> getDefaultActions() {
            List<Action.Builder> result = ActionsCopier.copyToBuilder(this.defaultActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultActions(Collection<Action.BuilderImpl> defaultActions) {
            this.defaultActions = ActionsCopier.copyFromBuilder(defaultActions);
        }

        @Override
        public final Builder defaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Action ... defaultActions) {
            this.defaultActions(Arrays.asList(defaultActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Consumer<Action.Builder> ... defaultActions) {
            this.defaultActions(Stream.of(defaultActions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAlpnPolicy() {
            if (this.alpnPolicy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alpnPolicy;
        }

        public final void setAlpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
        }

        @Override
        public final Builder alpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alpnPolicy(String ... alpnPolicy) {
            this.alpnPolicy(Arrays.asList(alpnPolicy));
            return this;
        }

        public Listener build() {
            return new Listener(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Listener> {
        public Builder listenerArn(String var1);

        public Builder loadBalancerArn(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder certificates(Collection<Certificate> var1);

        public Builder certificates(Certificate ... var1);

        public Builder certificates(Consumer<Certificate.Builder> ... var1);

        public Builder sslPolicy(String var1);

        public Builder defaultActions(Collection<Action> var1);

        public Builder defaultActions(Action ... var1);

        public Builder defaultActions(Consumer<Action.Builder> ... var1);

        public Builder alpnPolicy(Collection<String> var1);

        public Builder alpnPolicy(String ... var1);
    }
}

