/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessagesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateConfigurationSettingsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ValidateConfigurationSettingsResponse> {
    private static final SdkField<List<ValidationMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Messages").getter(ValidateConfigurationSettingsResponse.getter(ValidateConfigurationSettingsResponse::messages)).setter(ValidateConfigurationSettingsResponse.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD));
    private final List<ValidationMessage> messages;

    private ValidateConfigurationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<ValidationMessage> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateConfigurationSettingsResponse)) {
            return false;
        }
        ValidateConfigurationSettingsResponse other = (ValidateConfigurationSettingsResponse)((Object)obj);
        return this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateConfigurationSettingsResponse").add("Messages", this.hasMessages() ? this.messages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateConfigurationSettingsResponse, T> g) {
        return obj -> g.apply((ValidateConfigurationSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ValidationMessage> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateConfigurationSettingsResponse model) {
            super(model);
            this.messages(model.messages);
        }

        public final List<ValidationMessage.Builder> getMessages() {
            List<ValidationMessage.Builder> result = ValidationMessagesListCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder messages(Collection<ValidationMessage> messages) {
            this.messages = ValidationMessagesListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(ValidationMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<ValidationMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (ValidationMessage)((ValidationMessage.Builder)ValidationMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<ValidationMessage.BuilderImpl> messages) {
            this.messages = ValidationMessagesListCopier.copyFromBuilder(messages);
        }

        @Override
        public ValidateConfigurationSettingsResponse build() {
            return new ValidateConfigurationSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateConfigurationSettingsResponse> {
        public Builder messages(Collection<ValidationMessage> var1);

        public Builder messages(ValidationMessage ... var1);

        public Builder messages(Consumer<ValidationMessage.Builder> ... var1);
    }
}

