/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationResourceLifecycleRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, UpdateApplicationResourceLifecycleRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(UpdateApplicationResourceLifecycleRequest.getter(UpdateApplicationResourceLifecycleRequest::applicationName)).setter(UpdateApplicationResourceLifecycleRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<ApplicationResourceLifecycleConfig> RESOURCE_LIFECYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceLifecycleConfig").getter(UpdateApplicationResourceLifecycleRequest.getter(UpdateApplicationResourceLifecycleRequest::resourceLifecycleConfig)).setter(UpdateApplicationResourceLifecycleRequest.setter(Builder::resourceLifecycleConfig)).constructor(ApplicationResourceLifecycleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLifecycleConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, RESOURCE_LIFECYCLE_CONFIG_FIELD));
    private final String applicationName;
    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private UpdateApplicationResourceLifecycleRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return this.resourceLifecycleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLifecycleConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationResourceLifecycleRequest)) {
            return false;
        }
        UpdateApplicationResourceLifecycleRequest other = (UpdateApplicationResourceLifecycleRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.resourceLifecycleConfig(), other.resourceLifecycleConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationResourceLifecycleRequest").add("ApplicationName", (Object)this.applicationName()).add("ResourceLifecycleConfig", (Object)this.resourceLifecycleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "ResourceLifecycleConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationResourceLifecycleRequest, T> g) {
        return obj -> g.apply((UpdateApplicationResourceLifecycleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationResourceLifecycleRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return this.resourceLifecycleConfig != null ? this.resourceLifecycleConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationResourceLifecycleRequest build() {
            return new UpdateApplicationResourceLifecycleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationResourceLifecycleRequest> {
        public Builder applicationName(String var1);

        public Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig var1);

        default public Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return this.resourceLifecycleConfig((ApplicationResourceLifecycleConfig)((ApplicationResourceLifecycleConfig.Builder)ApplicationResourceLifecycleConfig.builder().applyMutation(resourceLifecycleConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

