/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstancesHealthAttribute {
    HEALTH_STATUS("HealthStatus"),
    COLOR("Color"),
    CAUSES("Causes"),
    APPLICATION_METRICS("ApplicationMetrics"),
    REFRESHED_AT("RefreshedAt"),
    LAUNCHED_AT("LaunchedAt"),
    SYSTEM("System"),
    DEPLOYMENT("Deployment"),
    AVAILABILITY_ZONE("AvailabilityZone"),
    INSTANCE_TYPE("InstanceType"),
    ALL("All"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstancesHealthAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstancesHealthAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstancesHealthAttribute.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstancesHealthAttribute> knownValues() {
        return Stream.of(InstancesHealthAttribute.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

