/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkMode {
    BRIDGE("bridge"),
    HOST("host"),
    AWSVPC("awsvpc"),
    NONE("none"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkMode> knownValues() {
        return Stream.of(NetworkMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

