/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecrpublic.EcrPublicClient;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageDetail;

public class DescribeImagesIterable
implements SdkIterable<DescribeImagesResponse> {
    private final EcrPublicClient client;
    private final DescribeImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImagesIterable(EcrPublicClient client, DescribeImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public Iterator<DescribeImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageDetail> imageDetails() {
        Function<DescribeImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageDetails() != null) {
                return response.imageDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImagesResponseFetcher
    implements SyncPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImagesResponse nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesIterable.this.client.describeImages(DescribeImagesIterable.this.firstRequest);
            }
            return DescribeImagesIterable.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

