/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2instanceconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendSerialConsoleSshPublicKeyRequest
extends Ec2InstanceConnectRequest
implements ToCopyableBuilder<Builder, SendSerialConsoleSshPublicKeyRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SendSerialConsoleSshPublicKeyRequest.getter(SendSerialConsoleSshPublicKeyRequest::instanceId)).setter(SendSerialConsoleSshPublicKeyRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Integer> SERIAL_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SerialPort").getter(SendSerialConsoleSshPublicKeyRequest.getter(SendSerialConsoleSshPublicKeyRequest::serialPort)).setter(SendSerialConsoleSshPublicKeyRequest.setter(Builder::serialPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialPort").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSHPublicKey").getter(SendSerialConsoleSshPublicKeyRequest.getter(SendSerialConsoleSshPublicKeyRequest::sshPublicKey)).setter(SendSerialConsoleSshPublicKeyRequest.setter(Builder::sshPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSHPublicKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SERIAL_PORT_FIELD, SSH_PUBLIC_KEY_FIELD));
    private final String instanceId;
    private final Integer serialPort;
    private final String sshPublicKey;

    private SendSerialConsoleSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.serialPort = builder.serialPort;
        this.sshPublicKey = builder.sshPublicKey;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Integer serialPort() {
        return this.serialPort;
    }

    public final String sshPublicKey() {
        return this.sshPublicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendSerialConsoleSshPublicKeyRequest)) {
            return false;
        }
        SendSerialConsoleSshPublicKeyRequest other = (SendSerialConsoleSshPublicKeyRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.serialPort(), other.serialPort()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey());
    }

    public final String toString() {
        return ToString.builder((String)"SendSerialConsoleSshPublicKeyRequest").add("InstanceId", (Object)this.instanceId()).add("SerialPort", (Object)this.serialPort()).add("SSHPublicKey", (Object)this.sshPublicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SerialPort": {
                return Optional.ofNullable(clazz.cast(this.serialPort()));
            }
            case "SSHPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendSerialConsoleSshPublicKeyRequest, T> g) {
        return obj -> g.apply((SendSerialConsoleSshPublicKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2InstanceConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private Integer serialPort;
        private String sshPublicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SendSerialConsoleSshPublicKeyRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.serialPort(model.serialPort);
            this.sshPublicKey(model.sshPublicKey);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getSerialPort() {
            return this.serialPort;
        }

        @Override
        public final Builder serialPort(Integer serialPort) {
            this.serialPort = serialPort;
            return this;
        }

        public final void setSerialPort(Integer serialPort) {
            this.serialPort = serialPort;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendSerialConsoleSshPublicKeyRequest build() {
            return new SendSerialConsoleSshPublicKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2InstanceConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendSerialConsoleSshPublicKeyRequest> {
        public Builder instanceId(String var1);

        public Builder serialPort(Integer var1);

        public Builder sshPublicKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

