/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PlacementStrategy {
    CLUSTER("cluster"),
    SPREAD("spread"),
    PARTITION("partition"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PlacementStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlacementStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PlacementStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlacementStrategy> knownValues() {
        return Stream.of(PlacementStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

