/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PoolCidrBlock;
import software.amazon.awssdk.services.ec2.model.PoolCidrBlocksSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ipv6Pool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ipv6Pool> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(Ipv6Pool.getter(Ipv6Pool::poolId)).setter(Ipv6Pool.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").unmarshallLocationName("poolId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Ipv6Pool.getter(Ipv6Pool::description)).setter(Ipv6Pool.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<PoolCidrBlock>> POOL_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PoolCidrBlocks").getter(Ipv6Pool.getter(Ipv6Pool::poolCidrBlocks)).setter(Ipv6Pool.setter(Builder::poolCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolCidrBlockSet").unmarshallLocationName("poolCidrBlockSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PoolCidrBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Ipv6Pool.getter(Ipv6Pool::tags)).setter(Ipv6Pool.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, DESCRIPTION_FIELD, POOL_CIDR_BLOCKS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String poolId;
    private final String description;
    private final List<PoolCidrBlock> poolCidrBlocks;
    private final List<Tag> tags;

    private Ipv6Pool(BuilderImpl builder) {
        this.poolId = builder.poolId;
        this.description = builder.description;
        this.poolCidrBlocks = builder.poolCidrBlocks;
        this.tags = builder.tags;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPoolCidrBlocks() {
        return this.poolCidrBlocks != null && !(this.poolCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<PoolCidrBlock> poolCidrBlocks() {
        return this.poolCidrBlocks;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPoolCidrBlocks() ? this.poolCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv6Pool)) {
            return false;
        }
        Ipv6Pool other = (Ipv6Pool)obj;
        return Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.description(), other.description()) && this.hasPoolCidrBlocks() == other.hasPoolCidrBlocks() && Objects.equals(this.poolCidrBlocks(), other.poolCidrBlocks()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Ipv6Pool").add("PoolId", (Object)this.poolId()).add("Description", (Object)this.description()).add("PoolCidrBlocks", this.hasPoolCidrBlocks() ? this.poolCidrBlocks() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PoolCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.poolCidrBlocks()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ipv6Pool, T> g) {
        return obj -> g.apply((Ipv6Pool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolId;
        private String description;
        private List<PoolCidrBlock> poolCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Ipv6Pool model) {
            this.poolId(model.poolId);
            this.description(model.description);
            this.poolCidrBlocks(model.poolCidrBlocks);
            this.tags(model.tags);
        }

        public final String getPoolId() {
            return this.poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<PoolCidrBlock.Builder> getPoolCidrBlocks() {
            List<PoolCidrBlock.Builder> result = PoolCidrBlocksSetCopier.copyToBuilder(this.poolCidrBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder poolCidrBlocks(Collection<PoolCidrBlock> poolCidrBlocks) {
            this.poolCidrBlocks = PoolCidrBlocksSetCopier.copy(poolCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolCidrBlocks(PoolCidrBlock ... poolCidrBlocks) {
            this.poolCidrBlocks(Arrays.asList(poolCidrBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolCidrBlocks(Consumer<PoolCidrBlock.Builder> ... poolCidrBlocks) {
            this.poolCidrBlocks(Stream.of(poolCidrBlocks).map(c -> (PoolCidrBlock)((PoolCidrBlock.Builder)PoolCidrBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPoolCidrBlocks(Collection<PoolCidrBlock.BuilderImpl> poolCidrBlocks) {
            this.poolCidrBlocks = PoolCidrBlocksSetCopier.copyFromBuilder(poolCidrBlocks);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public Ipv6Pool build() {
            return new Ipv6Pool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ipv6Pool> {
        public Builder poolId(String var1);

        public Builder description(String var1);

        public Builder poolCidrBlocks(Collection<PoolCidrBlock> var1);

        public Builder poolCidrBlocks(PoolCidrBlock ... var1);

        public Builder poolCidrBlocks(Consumer<PoolCidrBlock.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

