/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DiskType {
    HDD("hdd"),
    SSD("ssd"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DiskType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiskType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DiskType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiskType> knownValues() {
        return Stream.of(DiskType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

