/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStoreImageTaskResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateStoreImageTaskResponse> {
    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectKey").getter(CreateStoreImageTaskResponse.getter(CreateStoreImageTaskResponse::objectKey)).setter(CreateStoreImageTaskResponse.setter(Builder::objectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKey").unmarshallLocationName("objectKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_KEY_FIELD));
    private final String objectKey;

    private CreateStoreImageTaskResponse(BuilderImpl builder) {
        super(builder);
        this.objectKey = builder.objectKey;
    }

    public final String objectKey() {
        return this.objectKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.objectKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStoreImageTaskResponse)) {
            return false;
        }
        CreateStoreImageTaskResponse other = (CreateStoreImageTaskResponse)((Object)obj);
        return Objects.equals(this.objectKey(), other.objectKey());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStoreImageTaskResponse").add("ObjectKey", (Object)this.objectKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectKey": {
                return Optional.ofNullable(clazz.cast(this.objectKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStoreImageTaskResponse, T> g) {
        return obj -> g.apply((CreateStoreImageTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String objectKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStoreImageTaskResponse model) {
            super(model);
            this.objectKey(model.objectKey);
        }

        public final String getObjectKey() {
            return this.objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        public CreateStoreImageTaskResponse build() {
            return new CreateStoreImageTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStoreImageTaskResponse> {
        public Builder objectKey(String var1);
    }
}

