/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocalGatewayRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateLocalGatewayRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(CreateLocalGatewayRouteRequest.getter(CreateLocalGatewayRouteRequest::destinationCidrBlock)).setter(CreateLocalGatewayRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableId").getter(CreateLocalGatewayRouteRequest.getter(CreateLocalGatewayRouteRequest::localGatewayRouteTableId)).setter(CreateLocalGatewayRouteRequest.setter(Builder::localGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId").unmarshallLocationName("LocalGatewayRouteTableId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceGroupId").getter(CreateLocalGatewayRouteRequest.getter(CreateLocalGatewayRouteRequest::localGatewayVirtualInterfaceGroupId)).setter(CreateLocalGatewayRouteRequest.setter(Builder::localGatewayVirtualInterfaceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceGroupId").unmarshallLocationName("LocalGatewayVirtualInterfaceGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD));
    private final String destinationCidrBlock;
    private final String localGatewayRouteTableId;
    private final String localGatewayVirtualInterfaceGroupId;

    private CreateLocalGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String localGatewayRouteTableId() {
        return this.localGatewayRouteTableId;
    }

    public final String localGatewayVirtualInterfaceGroupId() {
        return this.localGatewayVirtualInterfaceGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocalGatewayRouteRequest)) {
            return false;
        }
        CreateLocalGatewayRouteRequest other = (CreateLocalGatewayRouteRequest)((Object)obj);
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.localGatewayRouteTableId(), other.localGatewayRouteTableId()) && Objects.equals(this.localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLocalGatewayRouteRequest").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("LocalGatewayRouteTableId", (Object)this.localGatewayRouteTableId()).add("LocalGatewayVirtualInterfaceGroupId", (Object)this.localGatewayVirtualInterfaceGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "LocalGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableId()));
            }
            case "LocalGatewayVirtualInterfaceGroupId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocalGatewayRouteRequest, T> g) {
        return obj -> g.apply((CreateLocalGatewayRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String localGatewayRouteTableId;
        private String localGatewayVirtualInterfaceGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocalGatewayRouteRequest model) {
            super(model);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.localGatewayRouteTableId(model.localGatewayRouteTableId);
            this.localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocalGatewayRouteRequest build() {
            return new CreateLocalGatewayRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocalGatewayRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder localGatewayRouteTableId(String var1);

        public Builder localGatewayVirtualInterfaceGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

