/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TrustState {
    CREATING("Creating"),
    CREATED("Created"),
    VERIFYING("Verifying"),
    VERIFY_FAILED("VerifyFailed"),
    VERIFIED("Verified"),
    UPDATING("Updating"),
    UPDATE_FAILED("UpdateFailed"),
    UPDATED("Updated"),
    DELETING("Deleting"),
    DELETED("Deleted"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TrustState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrustState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TrustState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrustState> knownValues() {
        return Stream.of(TrustState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

