/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.TopicNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventTopicsRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, DescribeEventTopicsRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DescribeEventTopicsRequest.getter(DescribeEventTopicsRequest::directoryId)).setter(DescribeEventTopicsRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<String>> TOPIC_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicNames").getter(DescribeEventTopicsRequest.getter(DescribeEventTopicsRequest::topicNames)).setter(DescribeEventTopicsRequest.setter(Builder::topicNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, TOPIC_NAMES_FIELD));
    private final String directoryId;
    private final List<String> topicNames;

    private DescribeEventTopicsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.topicNames = builder.topicNames;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasTopicNames() {
        return this.topicNames != null && !(this.topicNames instanceof SdkAutoConstructList);
    }

    public final List<String> topicNames() {
        return this.topicNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicNames() ? this.topicNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTopicsRequest)) {
            return false;
        }
        DescribeEventTopicsRequest other = (DescribeEventTopicsRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && this.hasTopicNames() == other.hasTopicNames() && Objects.equals(this.topicNames(), other.topicNames());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventTopicsRequest").add("DirectoryId", (Object)this.directoryId()).add("TopicNames", this.hasTopicNames() ? this.topicNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "TopicNames": {
                return Optional.ofNullable(clazz.cast(this.topicNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventTopicsRequest, T> g) {
        return obj -> g.apply((DescribeEventTopicsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<String> topicNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTopicsRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.topicNames(model.topicNames);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Collection<String> getTopicNames() {
            if (this.topicNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topicNames;
        }

        @Override
        public final Builder topicNames(Collection<String> topicNames) {
            this.topicNames = TopicNamesCopier.copy(topicNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicNames(String ... topicNames) {
            this.topicNames(Arrays.asList(topicNames));
            return this;
        }

        public final void setTopicNames(Collection<String> topicNames) {
            this.topicNames = TopicNamesCopier.copy(topicNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventTopicsRequest build() {
            return new DescribeEventTopicsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventTopicsRequest> {
        public Builder directoryId(String var1);

        public Builder topicNames(Collection<String> var1);

        public Builder topicNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

