/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalySourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalySourceDetails> {
    private static final SdkField<List<CloudWatchMetricsDetail>> CLOUD_WATCH_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchMetrics").getter(AnomalySourceDetails.getter(AnomalySourceDetails::cloudWatchMetrics)).setter(AnomalySourceDetails.setter(Builder::cloudWatchMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchMetricsDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CloudWatchMetricsDetail> cloudWatchMetrics;

    private AnomalySourceDetails(BuilderImpl builder) {
        this.cloudWatchMetrics = builder.cloudWatchMetrics;
    }

    public final boolean hasCloudWatchMetrics() {
        return this.cloudWatchMetrics != null && !(this.cloudWatchMetrics instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchMetricsDetail> cloudWatchMetrics() {
        return this.cloudWatchMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchMetrics() ? this.cloudWatchMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalySourceDetails)) {
            return false;
        }
        AnomalySourceDetails other = (AnomalySourceDetails)obj;
        return this.hasCloudWatchMetrics() == other.hasCloudWatchMetrics() && Objects.equals(this.cloudWatchMetrics(), other.cloudWatchMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalySourceDetails").add("CloudWatchMetrics", this.hasCloudWatchMetrics() ? this.cloudWatchMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchMetrics": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalySourceDetails, T> g) {
        return obj -> g.apply((AnomalySourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CloudWatchMetricsDetail> cloudWatchMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalySourceDetails model) {
            this.cloudWatchMetrics(model.cloudWatchMetrics);
        }

        public final List<CloudWatchMetricsDetail.Builder> getCloudWatchMetrics() {
            List<CloudWatchMetricsDetail.Builder> result = CloudWatchMetricsDetailsCopier.copyToBuilder(this.cloudWatchMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder cloudWatchMetrics(Collection<CloudWatchMetricsDetail> cloudWatchMetrics) {
            this.cloudWatchMetrics = CloudWatchMetricsDetailsCopier.copy(cloudWatchMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchMetrics(CloudWatchMetricsDetail ... cloudWatchMetrics) {
            this.cloudWatchMetrics(Arrays.asList(cloudWatchMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchMetrics(Consumer<CloudWatchMetricsDetail.Builder> ... cloudWatchMetrics) {
            this.cloudWatchMetrics(Stream.of(cloudWatchMetrics).map(c -> (CloudWatchMetricsDetail)((CloudWatchMetricsDetail.Builder)CloudWatchMetricsDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchMetrics(Collection<CloudWatchMetricsDetail.BuilderImpl> cloudWatchMetrics) {
            this.cloudWatchMetrics = CloudWatchMetricsDetailsCopier.copyFromBuilder(cloudWatchMetrics);
        }

        public AnomalySourceDetails build() {
            return new AnomalySourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalySourceDetails> {
        public Builder cloudWatchMetrics(Collection<CloudWatchMetricsDetail> var1);

        public Builder cloudWatchMetrics(CloudWatchMetricsDetail ... var1);

        public Builder cloudWatchMetrics(Consumer<CloudWatchMetricsDetail.Builder> ... var1);
    }
}

