/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse;

public class ListTestGridSessionsPublisher
implements SdkPublisher<ListTestGridSessionsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListTestGridSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestGridSessionsPublisher(DeviceFarmAsyncClient client, ListTestGridSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestGridSessionsPublisher(DeviceFarmAsyncClient client, ListTestGridSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestGridSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestGridSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestGridSessionsResponseFetcher
    implements AsyncPageFetcher<ListTestGridSessionsResponse> {
        private ListTestGridSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestGridSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestGridSessionsResponse> nextPage(ListTestGridSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListTestGridSessionsPublisher.this.client.listTestGridSessions(ListTestGridSessionsPublisher.this.firstRequest);
            }
            return ListTestGridSessionsPublisher.this.client.listTestGridSessions((ListTestGridSessionsRequest)((Object)ListTestGridSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

