/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryObjectsResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, QueryObjectsResponse> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ids").getter(QueryObjectsResponse.getter(QueryObjectsResponse::ids)).setter(QueryObjectsResponse.setter(Builder::ids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("marker").getter(QueryObjectsResponse.getter(QueryObjectsResponse::marker)).setter(QueryObjectsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marker").build()}).build();
    private static final SdkField<Boolean> HAS_MORE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasMoreResults").getter(QueryObjectsResponse.getter(QueryObjectsResponse::hasMoreResults)).setter(QueryObjectsResponse.setter(Builder::hasMoreResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasMoreResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD, MARKER_FIELD, HAS_MORE_RESULTS_FIELD));
    private final List<String> ids;
    private final String marker;
    private final Boolean hasMoreResults;

    private QueryObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    public final boolean hasIds() {
        return this.ids != null && !(this.ids instanceof SdkAutoConstructList);
    }

    public final List<String> ids() {
        return this.ids;
    }

    public final String marker() {
        return this.marker;
    }

    public final Boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIds() ? this.ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryObjectsResponse)) {
            return false;
        }
        QueryObjectsResponse other = (QueryObjectsResponse)((Object)obj);
        return this.hasIds() == other.hasIds() && Objects.equals(this.ids(), other.ids()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.hasMoreResults(), other.hasMoreResults());
    }

    public final String toString() {
        return ToString.builder((String)"QueryObjectsResponse").add("Ids", this.hasIds() ? this.ids() : null).add("Marker", (Object)this.marker()).add("HasMoreResults", (Object)this.hasMoreResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ids": {
                return Optional.ofNullable(clazz.cast(this.ids()));
            }
            case "marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "hasMoreResults": {
                return Optional.ofNullable(clazz.cast(this.hasMoreResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryObjectsResponse, T> g) {
        return obj -> g.apply((QueryObjectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryObjectsResponse model) {
            super(model);
            this.ids(model.ids);
            this.marker(model.marker);
            this.hasMoreResults(model.hasMoreResults);
        }

        public final Collection<String> getIds() {
            if (this.ids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = _idListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = _idListCopier.copy(ids);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return this.hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        @Override
        public QueryObjectsResponse build() {
            return new QueryObjectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryObjectsResponse> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder marker(String var1);

        public Builder hasMoreResults(Boolean var1);
    }
}

