/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeClient;
import software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListDataSetRevisionsResponse;
import software.amazon.awssdk.services.dataexchange.model.RevisionEntry;

public class ListDataSetRevisionsIterable
implements SdkIterable<ListDataSetRevisionsResponse> {
    private final DataExchangeClient client;
    private final ListDataSetRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSetRevisionsIterable(DataExchangeClient client, ListDataSetRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDataSetRevisionsResponseFetcher();
    }

    public Iterator<ListDataSetRevisionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RevisionEntry> revisions() {
        Function<ListDataSetRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.revisions() != null) {
                return response.revisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSetRevisionsResponseFetcher
    implements SyncPageFetcher<ListDataSetRevisionsResponse> {
        private ListDataSetRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSetRevisionsResponse nextPage(ListDataSetRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetRevisionsIterable.this.client.listDataSetRevisions(ListDataSetRevisionsIterable.this.firstRequest);
            }
            return ListDataSetRevisionsIterable.this.client.listDataSetRevisions((ListDataSetRevisionsRequest)((Object)ListDataSetRevisionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

