/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CsvOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CsvOptions> {
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(CsvOptions.getter(CsvOptions::delimiter)).setter(CsvOptions.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final SdkField<Boolean> HEADER_ROW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HeaderRow").getter(CsvOptions.getter(CsvOptions::headerRow)).setter(CsvOptions.setter(Builder::headerRow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderRow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIMITER_FIELD, HEADER_ROW_FIELD));
    private static final long serialVersionUID = 1L;
    private final String delimiter;
    private final Boolean headerRow;

    private CsvOptions(BuilderImpl builder) {
        this.delimiter = builder.delimiter;
        this.headerRow = builder.headerRow;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final Boolean headerRow() {
        return this.headerRow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.headerRow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsvOptions)) {
            return false;
        }
        CsvOptions other = (CsvOptions)obj;
        return Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.headerRow(), other.headerRow());
    }

    public final String toString() {
        return ToString.builder((String)"CsvOptions").add("Delimiter", (Object)this.delimiter()).add("HeaderRow", (Object)this.headerRow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "HeaderRow": {
                return Optional.ofNullable(clazz.cast(this.headerRow()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CsvOptions, T> g) {
        return obj -> g.apply((CsvOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String delimiter;
        private Boolean headerRow;

        private BuilderImpl() {
        }

        private BuilderImpl(CsvOptions model) {
            this.delimiter(model.delimiter);
            this.headerRow(model.headerRow);
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Boolean getHeaderRow() {
            return this.headerRow;
        }

        @Override
        public final Builder headerRow(Boolean headerRow) {
            this.headerRow = headerRow;
            return this;
        }

        public final void setHeaderRow(Boolean headerRow) {
            this.headerRow = headerRow;
        }

        public CsvOptions build() {
            return new CsvOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CsvOptions> {
        public Builder delimiter(String var1);

        public Builder headerRow(Boolean var1);
    }
}

