/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TargetDbType {
    SPECIFIC_DATABASE("specific-database"),
    MULTIPLE_DATABASES("multiple-databases"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TargetDbType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetDbType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TargetDbType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetDbType> knownValues() {
        return Stream.of(TargetDbType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

