/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Metric {
    BLENDED_COST("BLENDED_COST"),
    UNBLENDED_COST("UNBLENDED_COST"),
    AMORTIZED_COST("AMORTIZED_COST"),
    NET_UNBLENDED_COST("NET_UNBLENDED_COST"),
    NET_AMORTIZED_COST("NET_AMORTIZED_COST"),
    USAGE_QUANTITY("USAGE_QUANTITY"),
    NORMALIZED_USAGE_AMOUNT("NORMALIZED_USAGE_AMOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Metric(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Metric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Metric.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Metric> knownValues() {
        return Stream.of(Metric.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

