/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceStorageResourceType {
    CHAT_TRANSCRIPTS("CHAT_TRANSCRIPTS"),
    CALL_RECORDINGS("CALL_RECORDINGS"),
    SCHEDULED_REPORTS("SCHEDULED_REPORTS"),
    MEDIA_STREAMS("MEDIA_STREAMS"),
    CONTACT_TRACE_RECORDS("CONTACT_TRACE_RECORDS"),
    AGENT_EVENTS("AGENT_EVENTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceStorageResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceStorageResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceStorageResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceStorageResourceType> knownValues() {
        return Stream.of(InstanceStorageResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

