/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.MemberAccountRuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatusDetailFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatusDetailFilters> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(StatusDetailFilters.getter(StatusDetailFilters::accountId)).setter(StatusDetailFilters.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> MEMBER_ACCOUNT_RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberAccountRuleStatus").getter(StatusDetailFilters.getter(StatusDetailFilters::memberAccountRuleStatusAsString)).setter(StatusDetailFilters.setter(Builder::memberAccountRuleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccountRuleStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, MEMBER_ACCOUNT_RULE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String memberAccountRuleStatus;

    private StatusDetailFilters(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.memberAccountRuleStatus = builder.memberAccountRuleStatus;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final MemberAccountRuleStatus memberAccountRuleStatus() {
        return MemberAccountRuleStatus.fromValue(this.memberAccountRuleStatus);
    }

    public final String memberAccountRuleStatusAsString() {
        return this.memberAccountRuleStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountRuleStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusDetailFilters)) {
            return false;
        }
        StatusDetailFilters other = (StatusDetailFilters)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.memberAccountRuleStatusAsString(), other.memberAccountRuleStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StatusDetailFilters").add("AccountId", (Object)this.accountId()).add("MemberAccountRuleStatus", (Object)this.memberAccountRuleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "MemberAccountRuleStatus": {
                return Optional.ofNullable(clazz.cast(this.memberAccountRuleStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatusDetailFilters, T> g) {
        return obj -> g.apply((StatusDetailFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String memberAccountRuleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusDetailFilters model) {
            this.accountId(model.accountId);
            this.memberAccountRuleStatus(model.memberAccountRuleStatus);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getMemberAccountRuleStatus() {
            return this.memberAccountRuleStatus;
        }

        @Override
        public final Builder memberAccountRuleStatus(String memberAccountRuleStatus) {
            this.memberAccountRuleStatus = memberAccountRuleStatus;
            return this;
        }

        @Override
        public final Builder memberAccountRuleStatus(MemberAccountRuleStatus memberAccountRuleStatus) {
            this.memberAccountRuleStatus(memberAccountRuleStatus == null ? null : memberAccountRuleStatus.toString());
            return this;
        }

        public final void setMemberAccountRuleStatus(String memberAccountRuleStatus) {
            this.memberAccountRuleStatus = memberAccountRuleStatus;
        }

        public StatusDetailFilters build() {
            return new StatusDetailFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatusDetailFilters> {
        public Builder accountId(String var1);

        public Builder memberAccountRuleStatus(String var1);

        public Builder memberAccountRuleStatus(MemberAccountRuleStatus var1);
    }
}

