/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SyntaxLanguageCode {
    EN("en"),
    ES("es"),
    FR("fr"),
    DE("de"),
    IT("it"),
    PT("pt"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SyntaxLanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SyntaxLanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SyntaxLanguageCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SyntaxLanguageCode> knownValues() {
        return Stream.of(SyntaxLanguageCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

