/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.EntityLabel;
import software.amazon.awssdk.services.comprehend.model.ListOfEntityLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainsPiiEntitiesResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ContainsPiiEntitiesResponse> {
    private static final SdkField<List<EntityLabel>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(ContainsPiiEntitiesResponse.getter(ContainsPiiEntitiesResponse::labels)).setter(ContainsPiiEntitiesResponse.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD));
    private final List<EntityLabel> labels;

    private ContainsPiiEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.labels = builder.labels;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<EntityLabel> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainsPiiEntitiesResponse)) {
            return false;
        }
        ContainsPiiEntitiesResponse other = (ContainsPiiEntitiesResponse)((Object)obj);
        return this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels());
    }

    public final String toString() {
        return ToString.builder((String)"ContainsPiiEntitiesResponse").add("Labels", this.hasLabels() ? this.labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainsPiiEntitiesResponse, T> g) {
        return obj -> g.apply((ContainsPiiEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<EntityLabel> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainsPiiEntitiesResponse model) {
            super(model);
            this.labels(model.labels);
        }

        public final List<EntityLabel.Builder> getLabels() {
            List<EntityLabel.Builder> result = ListOfEntityLabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder labels(Collection<EntityLabel> labels) {
            this.labels = ListOfEntityLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(EntityLabel ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<EntityLabel.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (EntityLabel)((EntityLabel.Builder)EntityLabel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabels(Collection<EntityLabel.BuilderImpl> labels) {
            this.labels = ListOfEntityLabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public ContainsPiiEntitiesResponse build() {
            return new ContainsPiiEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ContainsPiiEntitiesResponse> {
        public Builder labels(Collection<EntityLabel> var1);

        public Builder labels(EntityLabel ... var1);

        public Builder labels(Consumer<EntityLabel.Builder> ... var1);
    }
}

