/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TeamMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TeamMember> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userArn").getter(TeamMember.getter(TeamMember::userArn)).setter(TeamMember.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final SdkField<String> PROJECT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectRole").getter(TeamMember.getter(TeamMember::projectRole)).setter(TeamMember.setter(Builder::projectRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectRole").build()}).build();
    private static final SdkField<Boolean> REMOTE_ACCESS_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("remoteAccessAllowed").getter(TeamMember.getter(TeamMember::remoteAccessAllowed)).setter(TeamMember.setter(Builder::remoteAccessAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessAllowed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD, PROJECT_ROLE_FIELD, REMOTE_ACCESS_ALLOWED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userArn;
    private final String projectRole;
    private final Boolean remoteAccessAllowed;

    private TeamMember(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.projectRole = builder.projectRole;
        this.remoteAccessAllowed = builder.remoteAccessAllowed;
    }

    public final String userArn() {
        return this.userArn;
    }

    public final String projectRole() {
        return this.projectRole;
    }

    public final Boolean remoteAccessAllowed() {
        return this.remoteAccessAllowed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessAllowed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeamMember)) {
            return false;
        }
        TeamMember other = (TeamMember)obj;
        return Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.projectRole(), other.projectRole()) && Objects.equals(this.remoteAccessAllowed(), other.remoteAccessAllowed());
    }

    public final String toString() {
        return ToString.builder((String)"TeamMember").add("UserArn", (Object)this.userArn()).add("ProjectRole", (Object)this.projectRole()).add("RemoteAccessAllowed", (Object)this.remoteAccessAllowed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "projectRole": {
                return Optional.ofNullable(clazz.cast(this.projectRole()));
            }
            case "remoteAccessAllowed": {
                return Optional.ofNullable(clazz.cast(this.remoteAccessAllowed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TeamMember, T> g) {
        return obj -> g.apply((TeamMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userArn;
        private String projectRole;
        private Boolean remoteAccessAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(TeamMember model) {
            this.userArn(model.userArn);
            this.projectRole(model.projectRole);
            this.remoteAccessAllowed(model.remoteAccessAllowed);
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getProjectRole() {
            return this.projectRole;
        }

        @Override
        public final Builder projectRole(String projectRole) {
            this.projectRole = projectRole;
            return this;
        }

        public final void setProjectRole(String projectRole) {
            this.projectRole = projectRole;
        }

        public final Boolean getRemoteAccessAllowed() {
            return this.remoteAccessAllowed;
        }

        @Override
        public final Builder remoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
            return this;
        }

        public final void setRemoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
        }

        public TeamMember build() {
            return new TeamMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TeamMember> {
        public Builder userArn(String var1);

        public Builder projectRole(String var1);

        public Builder remoteAccessAllowed(Boolean var1);
    }
}

