/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetailListCopier;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActionExecutionsResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, ListActionExecutionsResponse> {
    private static final SdkField<List<ActionExecutionDetail>> ACTION_EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionExecutionDetails").getter(ListActionExecutionsResponse.getter(ListActionExecutionsResponse::actionExecutionDetails)).setter(ListActionExecutionsResponse.setter(Builder::actionExecutionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionExecutionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActionExecutionsResponse.getter(ListActionExecutionsResponse::nextToken)).setter(ListActionExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_EXECUTION_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ActionExecutionDetail> actionExecutionDetails;
    private final String nextToken;

    private ListActionExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.actionExecutionDetails = builder.actionExecutionDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActionExecutionDetails() {
        return this.actionExecutionDetails != null && !(this.actionExecutionDetails instanceof SdkAutoConstructList);
    }

    public final List<ActionExecutionDetail> actionExecutionDetails() {
        return this.actionExecutionDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionExecutionDetails() ? this.actionExecutionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionExecutionsResponse)) {
            return false;
        }
        ListActionExecutionsResponse other = (ListActionExecutionsResponse)((Object)obj);
        return this.hasActionExecutionDetails() == other.hasActionExecutionDetails() && Objects.equals(this.actionExecutionDetails(), other.actionExecutionDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListActionExecutionsResponse").add("ActionExecutionDetails", this.hasActionExecutionDetails() ? this.actionExecutionDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionExecutionDetails": {
                return Optional.ofNullable(clazz.cast(this.actionExecutionDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListActionExecutionsResponse, T> g) {
        return obj -> g.apply((ListActionExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private List<ActionExecutionDetail> actionExecutionDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionExecutionsResponse model) {
            super(model);
            this.actionExecutionDetails(model.actionExecutionDetails);
            this.nextToken(model.nextToken);
        }

        public final List<ActionExecutionDetail.Builder> getActionExecutionDetails() {
            List<ActionExecutionDetail.Builder> result = ActionExecutionDetailListCopier.copyToBuilder(this.actionExecutionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder actionExecutionDetails(Collection<ActionExecutionDetail> actionExecutionDetails) {
            this.actionExecutionDetails = ActionExecutionDetailListCopier.copy(actionExecutionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionExecutionDetails(ActionExecutionDetail ... actionExecutionDetails) {
            this.actionExecutionDetails(Arrays.asList(actionExecutionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionExecutionDetails(Consumer<ActionExecutionDetail.Builder> ... actionExecutionDetails) {
            this.actionExecutionDetails(Stream.of(actionExecutionDetails).map(c -> (ActionExecutionDetail)((ActionExecutionDetail.Builder)ActionExecutionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActionExecutionDetails(Collection<ActionExecutionDetail.BuilderImpl> actionExecutionDetails) {
            this.actionExecutionDetails = ActionExecutionDetailListCopier.copyFromBuilder(actionExecutionDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListActionExecutionsResponse build() {
            return new ListActionExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActionExecutionsResponse> {
        public Builder actionExecutionDetails(Collection<ActionExecutionDetail> var1);

        public Builder actionExecutionDetails(ActionExecutionDetail ... var1);

        public Builder actionExecutionDetails(Consumer<ActionExecutionDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

