/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PullRequestEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePullRequestEventsRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, DescribePullRequestEventsRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestId").getter(DescribePullRequestEventsRequest.getter(DescribePullRequestEventsRequest::pullRequestId)).setter(DescribePullRequestEventsRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> PULL_REQUEST_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestEventType").getter(DescribePullRequestEventsRequest.getter(DescribePullRequestEventsRequest::pullRequestEventTypeAsString)).setter(DescribePullRequestEventsRequest.setter(Builder::pullRequestEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEventType").build()}).build();
    private static final SdkField<String> ACTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actorArn").getter(DescribePullRequestEventsRequest.getter(DescribePullRequestEventsRequest::actorArn)).setter(DescribePullRequestEventsRequest.setter(Builder::actorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribePullRequestEventsRequest.getter(DescribePullRequestEventsRequest::nextToken)).setter(DescribePullRequestEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribePullRequestEventsRequest.getter(DescribePullRequestEventsRequest::maxResults)).setter(DescribePullRequestEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, PULL_REQUEST_EVENT_TYPE_FIELD, ACTOR_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String pullRequestId;
    private final String pullRequestEventType;
    private final String actorArn;
    private final String nextToken;
    private final Integer maxResults;

    private DescribePullRequestEventsRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.pullRequestEventType = builder.pullRequestEventType;
        this.actorArn = builder.actorArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String pullRequestId() {
        return this.pullRequestId;
    }

    public final PullRequestEventType pullRequestEventType() {
        return PullRequestEventType.fromValue(this.pullRequestEventType);
    }

    public final String pullRequestEventTypeAsString() {
        return this.pullRequestEventType;
    }

    public final String actorArn() {
        return this.actorArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePullRequestEventsRequest)) {
            return false;
        }
        DescribePullRequestEventsRequest other = (DescribePullRequestEventsRequest)((Object)obj);
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.pullRequestEventTypeAsString(), other.pullRequestEventTypeAsString()) && Objects.equals(this.actorArn(), other.actorArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePullRequestEventsRequest").add("PullRequestId", (Object)this.pullRequestId()).add("PullRequestEventType", (Object)this.pullRequestEventTypeAsString()).add("ActorArn", (Object)this.actorArn()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "pullRequestEventType": {
                return Optional.ofNullable(clazz.cast(this.pullRequestEventTypeAsString()));
            }
            case "actorArn": {
                return Optional.ofNullable(clazz.cast(this.actorArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePullRequestEventsRequest, T> g) {
        return obj -> g.apply((DescribePullRequestEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String pullRequestEventType;
        private String actorArn;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePullRequestEventsRequest model) {
            super(model);
            this.pullRequestId(model.pullRequestId);
            this.pullRequestEventType(model.pullRequestEventType);
            this.actorArn(model.actorArn);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getPullRequestEventType() {
            return this.pullRequestEventType;
        }

        @Override
        public final Builder pullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
            return this;
        }

        @Override
        public final Builder pullRequestEventType(PullRequestEventType pullRequestEventType) {
            this.pullRequestEventType(pullRequestEventType == null ? null : pullRequestEventType.toString());
            return this;
        }

        public final void setPullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
        }

        public final String getActorArn() {
            return this.actorArn;
        }

        @Override
        public final Builder actorArn(String actorArn) {
            this.actorArn = actorArn;
            return this;
        }

        public final void setActorArn(String actorArn) {
            this.actorArn = actorArn;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePullRequestEventsRequest build() {
            return new DescribePullRequestEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePullRequestEventsRequest> {
        public Builder pullRequestId(String var1);

        public Builder pullRequestEventType(String var1);

        public Builder pullRequestEventType(PullRequestEventType var1);

        public Builder actorArn(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

