/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.services.codebuild.model.BuildNotDeleted;
import software.amazon.awssdk.services.codebuild.model.BuildsNotDeletedCopier;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteBuildsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchDeleteBuildsResponse> {
    private static final SdkField<List<String>> BUILDS_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buildsDeleted").getter(BatchDeleteBuildsResponse.getter(BatchDeleteBuildsResponse::buildsDeleted)).setter(BatchDeleteBuildsResponse.setter(Builder::buildsDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsDeleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BuildNotDeleted>> BUILDS_NOT_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buildsNotDeleted").getter(BatchDeleteBuildsResponse.getter(BatchDeleteBuildsResponse::buildsNotDeleted)).setter(BatchDeleteBuildsResponse.setter(Builder::buildsNotDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsNotDeleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildNotDeleted::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILDS_DELETED_FIELD, BUILDS_NOT_DELETED_FIELD));
    private final List<String> buildsDeleted;
    private final List<BuildNotDeleted> buildsNotDeleted;

    private BatchDeleteBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.buildsDeleted = builder.buildsDeleted;
        this.buildsNotDeleted = builder.buildsNotDeleted;
    }

    public final boolean hasBuildsDeleted() {
        return this.buildsDeleted != null && !(this.buildsDeleted instanceof SdkAutoConstructList);
    }

    public final List<String> buildsDeleted() {
        return this.buildsDeleted;
    }

    public final boolean hasBuildsNotDeleted() {
        return this.buildsNotDeleted != null && !(this.buildsNotDeleted instanceof SdkAutoConstructList);
    }

    public final List<BuildNotDeleted> buildsNotDeleted() {
        return this.buildsNotDeleted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuildsDeleted() ? this.buildsDeleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuildsNotDeleted() ? this.buildsNotDeleted() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteBuildsResponse)) {
            return false;
        }
        BatchDeleteBuildsResponse other = (BatchDeleteBuildsResponse)((Object)obj);
        return this.hasBuildsDeleted() == other.hasBuildsDeleted() && Objects.equals(this.buildsDeleted(), other.buildsDeleted()) && this.hasBuildsNotDeleted() == other.hasBuildsNotDeleted() && Objects.equals(this.buildsNotDeleted(), other.buildsNotDeleted());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteBuildsResponse").add("BuildsDeleted", this.hasBuildsDeleted() ? this.buildsDeleted() : null).add("BuildsNotDeleted", this.hasBuildsNotDeleted() ? this.buildsNotDeleted() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "buildsDeleted": {
                return Optional.ofNullable(clazz.cast(this.buildsDeleted()));
            }
            case "buildsNotDeleted": {
                return Optional.ofNullable(clazz.cast(this.buildsNotDeleted()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteBuildsResponse, T> g) {
        return obj -> g.apply((BatchDeleteBuildsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<String> buildsDeleted = DefaultSdkAutoConstructList.getInstance();
        private List<BuildNotDeleted> buildsNotDeleted = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteBuildsResponse model) {
            super(model);
            this.buildsDeleted(model.buildsDeleted);
            this.buildsNotDeleted(model.buildsNotDeleted);
        }

        public final Collection<String> getBuildsDeleted() {
            if (this.buildsDeleted instanceof SdkAutoConstructList) {
                return null;
            }
            return this.buildsDeleted;
        }

        @Override
        public final Builder buildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsDeleted(String ... buildsDeleted) {
            this.buildsDeleted(Arrays.asList(buildsDeleted));
            return this;
        }

        public final void setBuildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
        }

        public final List<BuildNotDeleted.Builder> getBuildsNotDeleted() {
            List<BuildNotDeleted.Builder> result = BuildsNotDeletedCopier.copyToBuilder(this.buildsNotDeleted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder buildsNotDeleted(Collection<BuildNotDeleted> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copy(buildsNotDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(BuildNotDeleted ... buildsNotDeleted) {
            this.buildsNotDeleted(Arrays.asList(buildsNotDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(Consumer<BuildNotDeleted.Builder> ... buildsNotDeleted) {
            this.buildsNotDeleted(Stream.of(buildsNotDeleted).map(c -> (BuildNotDeleted)((BuildNotDeleted.Builder)BuildNotDeleted.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBuildsNotDeleted(Collection<BuildNotDeleted.BuilderImpl> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copyFromBuilder(buildsNotDeleted);
        }

        @Override
        public BatchDeleteBuildsResponse build() {
            return new BatchDeleteBuildsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteBuildsResponse> {
        public Builder buildsDeleted(Collection<String> var1);

        public Builder buildsDeleted(String ... var1);

        public Builder buildsNotDeleted(Collection<BuildNotDeleted> var1);

        public Builder buildsNotDeleted(BuildNotDeleted ... var1);

        public Builder buildsNotDeleted(Consumer<BuildNotDeleted.Builder> ... var1);
    }
}

