/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Expression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Expression> {
    private static final SdkField<String> EXPRESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpressionName").getter(Expression.getter(Expression::expressionName)).setter(Expression.setter(Builder::expressionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionName").build()}).build();
    private static final SdkField<String> EXPRESSION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpressionValue").getter(Expression.getter(Expression::expressionValue)).setter(Expression.setter(Builder::expressionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_NAME_FIELD, EXPRESSION_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String expressionName;
    private final String expressionValue;

    private Expression(BuilderImpl builder) {
        this.expressionName = builder.expressionName;
        this.expressionValue = builder.expressionValue;
    }

    public final String expressionName() {
        return this.expressionName;
    }

    public final String expressionValue() {
        return this.expressionValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        return Objects.equals(this.expressionName(), other.expressionName()) && Objects.equals(this.expressionValue(), other.expressionValue());
    }

    public final String toString() {
        return ToString.builder((String)"Expression").add("ExpressionName", (Object)this.expressionName()).add("ExpressionValue", (Object)this.expressionValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpressionName": {
                return Optional.ofNullable(clazz.cast(this.expressionName()));
            }
            case "ExpressionValue": {
                return Optional.ofNullable(clazz.cast(this.expressionValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expressionName;
        private String expressionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            this.expressionName(model.expressionName);
            this.expressionValue(model.expressionValue);
        }

        public final String getExpressionName() {
            return this.expressionName;
        }

        @Override
        public final Builder expressionName(String expressionName) {
            this.expressionName = expressionName;
            return this;
        }

        public final void setExpressionName(String expressionName) {
            this.expressionName = expressionName;
        }

        public final String getExpressionValue() {
            return this.expressionValue;
        }

        @Override
        public final Builder expressionValue(String expressionValue) {
            this.expressionValue = expressionValue;
            return this;
        }

        public final void setExpressionValue(String expressionValue) {
            this.expressionValue = expressionValue;
        }

        public Expression build() {
            return new Expression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Expression> {
        public Builder expressionName(String var1);

        public Builder expressionValue(String var1);
    }
}

