/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteHsmRequest
extends CloudHsmV2Request
implements ToCopyableBuilder<Builder, DeleteHsmRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(DeleteHsmRequest.getter(DeleteHsmRequest::clusterId)).setter(DeleteHsmRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> HSM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmId").getter(DeleteHsmRequest.getter(DeleteHsmRequest::hsmId)).setter(DeleteHsmRequest.setter(Builder::hsmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmId").build()}).build();
    private static final SdkField<String> ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniId").getter(DeleteHsmRequest.getter(DeleteHsmRequest::eniId)).setter(DeleteHsmRequest.setter(Builder::eniId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniId").build()}).build();
    private static final SdkField<String> ENI_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EniIp").getter(DeleteHsmRequest.getter(DeleteHsmRequest::eniIp)).setter(DeleteHsmRequest.setter(Builder::eniIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EniIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, HSM_ID_FIELD, ENI_ID_FIELD, ENI_IP_FIELD));
    private final String clusterId;
    private final String hsmId;
    private final String eniId;
    private final String eniIp;

    private DeleteHsmRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.hsmId = builder.hsmId;
        this.eniId = builder.eniId;
        this.eniIp = builder.eniIp;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String hsmId() {
        return this.hsmId;
    }

    public final String eniId() {
        return this.eniId;
    }

    public final String eniIp() {
        return this.eniIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHsmRequest)) {
            return false;
        }
        DeleteHsmRequest other = (DeleteHsmRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.hsmId(), other.hsmId()) && Objects.equals(this.eniId(), other.eniId()) && Objects.equals(this.eniIp(), other.eniIp());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteHsmRequest").add("ClusterId", (Object)this.clusterId()).add("HsmId", (Object)this.hsmId()).add("EniId", (Object)this.eniId()).add("EniIp", (Object)this.eniIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "HsmId": {
                return Optional.ofNullable(clazz.cast(this.hsmId()));
            }
            case "EniId": {
                return Optional.ofNullable(clazz.cast(this.eniId()));
            }
            case "EniIp": {
                return Optional.ofNullable(clazz.cast(this.eniIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteHsmRequest, T> g) {
        return obj -> g.apply((DeleteHsmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Request.BuilderImpl
    implements Builder {
        private String clusterId;
        private String hsmId;
        private String eniId;
        private String eniIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHsmRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.hsmId(model.hsmId);
            this.eniId(model.eniId);
            this.eniIp(model.eniIp);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getHsmId() {
            return this.hsmId;
        }

        @Override
        public final Builder hsmId(String hsmId) {
            this.hsmId = hsmId;
            return this;
        }

        public final void setHsmId(String hsmId) {
            this.hsmId = hsmId;
        }

        public final String getEniId() {
            return this.eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        public final String getEniIp() {
            return this.eniIp;
        }

        @Override
        public final Builder eniIp(String eniIp) {
            this.eniIp = eniIp;
            return this;
        }

        public final void setEniIp(String eniIp) {
            this.eniIp = eniIp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteHsmRequest build() {
            return new DeleteHsmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteHsmRequest> {
        public Builder clusterId(String var1);

        public Builder hsmId(String var1);

        public Builder eniId(String var1);

        public Builder eniIp(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

