/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloud9.model.Permissions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentMember> {
    private static final SdkField<String> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissions").getter(EnvironmentMember.getter(EnvironmentMember::permissionsAsString)).setter(EnvironmentMember.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(EnvironmentMember.getter(EnvironmentMember::userId)).setter(EnvironmentMember.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userArn").getter(EnvironmentMember.getter(EnvironmentMember::userArn)).setter(EnvironmentMember.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(EnvironmentMember.getter(EnvironmentMember::environmentId)).setter(EnvironmentMember.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<Instant> LAST_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastAccess").getter(EnvironmentMember.getter(EnvironmentMember::lastAccess)).setter(EnvironmentMember.setter(Builder::lastAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD, USER_ID_FIELD, USER_ARN_FIELD, ENVIRONMENT_ID_FIELD, LAST_ACCESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String permissions;
    private final String userId;
    private final String userArn;
    private final String environmentId;
    private final Instant lastAccess;

    private EnvironmentMember(BuilderImpl builder) {
        this.permissions = builder.permissions;
        this.userId = builder.userId;
        this.userArn = builder.userArn;
        this.environmentId = builder.environmentId;
        this.lastAccess = builder.lastAccess;
    }

    public final Permissions permissions() {
        return Permissions.fromValue(this.permissions);
    }

    public final String permissionsAsString() {
        return this.permissions;
    }

    public final String userId() {
        return this.userId;
    }

    public final String userArn() {
        return this.userArn;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final Instant lastAccess() {
        return this.lastAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentMember)) {
            return false;
        }
        EnvironmentMember other = (EnvironmentMember)obj;
        return Objects.equals(this.permissionsAsString(), other.permissionsAsString()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.lastAccess(), other.lastAccess());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentMember").add("Permissions", (Object)this.permissionsAsString()).add("UserId", (Object)this.userId()).add("UserArn", (Object)this.userArn()).add("EnvironmentId", (Object)this.environmentId()).add("LastAccess", (Object)this.lastAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsString()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "lastAccess": {
                return Optional.ofNullable(clazz.cast(this.lastAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentMember, T> g) {
        return obj -> g.apply((EnvironmentMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String permissions;
        private String userId;
        private String userArn;
        private String environmentId;
        private Instant lastAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentMember model) {
            this.permissions(model.permissions);
            this.userId(model.userId);
            this.userArn(model.userArn);
            this.environmentId(model.environmentId);
            this.lastAccess(model.lastAccess);
        }

        public final String getPermissions() {
            return this.permissions;
        }

        @Override
        public final Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public final Builder permissions(Permissions permissions) {
            this.permissions(permissions == null ? null : permissions.toString());
            return this;
        }

        public final void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final Instant getLastAccess() {
            return this.lastAccess;
        }

        @Override
        public final Builder lastAccess(Instant lastAccess) {
            this.lastAccess = lastAccess;
            return this;
        }

        public final void setLastAccess(Instant lastAccess) {
            this.lastAccess = lastAccess;
        }

        public EnvironmentMember build() {
            return new EnvironmentMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentMember> {
        public Builder permissions(String var1);

        public Builder permissions(Permissions var1);

        public Builder userId(String var1);

        public Builder userArn(String var1);

        public Builder environmentId(String var1);

        public Builder lastAccess(Instant var1);
    }
}

