/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.AlexaForBusinessMetadata;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.License;
import software.amazon.awssdk.services.chime.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(UpdateUserRequest.getter(UpdateUserRequest::accountId)).setter(UpdateUserRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UpdateUserRequest.getter(UpdateUserRequest::userId)).setter(UpdateUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseType").getter(UpdateUserRequest.getter(UpdateUserRequest::licenseTypeAsString)).setter(UpdateUserRequest.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()}).build();
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserType").getter(UpdateUserRequest.getter(UpdateUserRequest::userTypeAsString)).setter(UpdateUserRequest.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserType").build()}).build();
    private static final SdkField<AlexaForBusinessMetadata> ALEXA_FOR_BUSINESS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlexaForBusinessMetadata").getter(UpdateUserRequest.getter(UpdateUserRequest::alexaForBusinessMetadata)).setter(UpdateUserRequest.setter(Builder::alexaForBusinessMetadata)).constructor(AlexaForBusinessMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaForBusinessMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, USER_ID_FIELD, LICENSE_TYPE_FIELD, USER_TYPE_FIELD, ALEXA_FOR_BUSINESS_METADATA_FIELD));
    private final String accountId;
    private final String userId;
    private final String licenseType;
    private final String userType;
    private final AlexaForBusinessMetadata alexaForBusinessMetadata;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.userId = builder.userId;
        this.licenseType = builder.licenseType;
        this.userType = builder.userType;
        this.alexaForBusinessMetadata = builder.alexaForBusinessMetadata;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String userId() {
        return this.userId;
    }

    public final License licenseType() {
        return License.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final UserType userType() {
        return UserType.fromValue(this.userType);
    }

    public final String userTypeAsString() {
        return this.userType;
    }

    public final AlexaForBusinessMetadata alexaForBusinessMetadata() {
        return this.alexaForBusinessMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alexaForBusinessMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.userTypeAsString(), other.userTypeAsString()) && Objects.equals(this.alexaForBusinessMetadata(), other.alexaForBusinessMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("AccountId", (Object)this.accountId()).add("UserId", (Object)this.userId()).add("LicenseType", (Object)this.licenseTypeAsString()).add("UserType", (Object)this.userTypeAsString()).add("AlexaForBusinessMetadata", (Object)this.alexaForBusinessMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "UserType": {
                return Optional.ofNullable(clazz.cast(this.userTypeAsString()));
            }
            case "AlexaForBusinessMetadata": {
                return Optional.ofNullable(clazz.cast(this.alexaForBusinessMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String userId;
        private String licenseType;
        private String userType;
        private AlexaForBusinessMetadata alexaForBusinessMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.userId(model.userId);
            this.licenseType(model.licenseType);
            this.userType(model.userType);
            this.alexaForBusinessMetadata(model.alexaForBusinessMetadata);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(License licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getUserType() {
            return this.userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        public final AlexaForBusinessMetadata.Builder getAlexaForBusinessMetadata() {
            return this.alexaForBusinessMetadata != null ? this.alexaForBusinessMetadata.toBuilder() : null;
        }

        @Override
        public final Builder alexaForBusinessMetadata(AlexaForBusinessMetadata alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata;
            return this;
        }

        public final void setAlexaForBusinessMetadata(AlexaForBusinessMetadata.BuilderImpl alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata != null ? alexaForBusinessMetadata.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder accountId(String var1);

        public Builder userId(String var1);

        public Builder licenseType(String var1);

        public Builder licenseType(License var1);

        public Builder userType(String var1);

        public Builder userType(UserType var1);

        public Builder alexaForBusinessMetadata(AlexaForBusinessMetadata var1);

        default public Builder alexaForBusinessMetadata(Consumer<AlexaForBusinessMetadata.Builder> alexaForBusinessMetadata) {
            return this.alexaForBusinessMetadata((AlexaForBusinessMetadata)((AlexaForBusinessMetadata.Builder)AlexaForBusinessMetadata.builder().applyMutation(alexaForBusinessMetadata)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

