/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.Capability;
import software.amazon.awssdk.services.chime.model.CapabilityListCopier;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.GeoMatchLevel;
import software.amazon.awssdk.services.chime.model.GeoMatchParams;
import software.amazon.awssdk.services.chime.model.NumberSelectionBehavior;
import software.amazon.awssdk.services.chime.model.ParticipantPhoneNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProxySessionRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateProxySessionRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(CreateProxySessionRequest.getter(CreateProxySessionRequest::voiceConnectorId)).setter(CreateProxySessionRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<List<String>> PARTICIPANT_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParticipantPhoneNumbers").getter(CreateProxySessionRequest.getter(CreateProxySessionRequest::participantPhoneNumbers)).setter(CreateProxySessionRequest.setter(Builder::participantPhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantPhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateProxySessionRequest.getter(CreateProxySessionRequest::name)).setter(CreateProxySessionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> EXPIRY_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpiryMinutes").getter(CreateProxySessionRequest.getter(CreateProxySessionRequest::expiryMinutes)).setter(CreateProxySessionRequest.setter(Builder::expiryMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryMinutes").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(CreateProxySessionRequest.getter(CreateProxySessionRequest::capabilitiesAsStrings)).setter(CreateProxySessionRequest.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NUMBER_SELECTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberSelectionBehavior").getter(CreateProxySessionRequest.getter(CreateProxySessionRequest::numberSelectionBehaviorAsString)).setter(CreateProxySessionRequest.setter(Builder::numberSelectionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberSelectionBehavior").build()}).build();
    private static final SdkField<String> GEO_MATCH_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeoMatchLevel").getter(CreateProxySessionRequest.getter(CreateProxySessionRequest::geoMatchLevelAsString)).setter(CreateProxySessionRequest.setter(Builder::geoMatchLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchLevel").build()}).build();
    private static final SdkField<GeoMatchParams> GEO_MATCH_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeoMatchParams").getter(CreateProxySessionRequest.getter(CreateProxySessionRequest::geoMatchParams)).setter(CreateProxySessionRequest.setter(Builder::geoMatchParams)).constructor(GeoMatchParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchParams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, PARTICIPANT_PHONE_NUMBERS_FIELD, NAME_FIELD, EXPIRY_MINUTES_FIELD, CAPABILITIES_FIELD, NUMBER_SELECTION_BEHAVIOR_FIELD, GEO_MATCH_LEVEL_FIELD, GEO_MATCH_PARAMS_FIELD));
    private final String voiceConnectorId;
    private final List<String> participantPhoneNumbers;
    private final String name;
    private final Integer expiryMinutes;
    private final List<String> capabilities;
    private final String numberSelectionBehavior;
    private final String geoMatchLevel;
    private final GeoMatchParams geoMatchParams;

    private CreateProxySessionRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.participantPhoneNumbers = builder.participantPhoneNumbers;
        this.name = builder.name;
        this.expiryMinutes = builder.expiryMinutes;
        this.capabilities = builder.capabilities;
        this.numberSelectionBehavior = builder.numberSelectionBehavior;
        this.geoMatchLevel = builder.geoMatchLevel;
        this.geoMatchParams = builder.geoMatchParams;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final boolean hasParticipantPhoneNumbers() {
        return this.participantPhoneNumbers != null && !(this.participantPhoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<String> participantPhoneNumbers() {
        return this.participantPhoneNumbers;
    }

    public final String name() {
        return this.name;
    }

    public final Integer expiryMinutes() {
        return this.expiryMinutes;
    }

    public final List<Capability> capabilities() {
        return CapabilityListCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final NumberSelectionBehavior numberSelectionBehavior() {
        return NumberSelectionBehavior.fromValue(this.numberSelectionBehavior);
    }

    public final String numberSelectionBehaviorAsString() {
        return this.numberSelectionBehavior;
    }

    public final GeoMatchLevel geoMatchLevel() {
        return GeoMatchLevel.fromValue(this.geoMatchLevel);
    }

    public final String geoMatchLevelAsString() {
        return this.geoMatchLevel;
    }

    public final GeoMatchParams geoMatchParams() {
        return this.geoMatchParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParticipantPhoneNumbers() ? this.participantPhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberSelectionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchParams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxySessionRequest)) {
            return false;
        }
        CreateProxySessionRequest other = (CreateProxySessionRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && this.hasParticipantPhoneNumbers() == other.hasParticipantPhoneNumbers() && Objects.equals(this.participantPhoneNumbers(), other.participantPhoneNumbers()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.expiryMinutes(), other.expiryMinutes()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.numberSelectionBehaviorAsString(), other.numberSelectionBehaviorAsString()) && Objects.equals(this.geoMatchLevelAsString(), other.geoMatchLevelAsString()) && Objects.equals(this.geoMatchParams(), other.geoMatchParams());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProxySessionRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("ParticipantPhoneNumbers", (Object)(this.participantPhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ExpiryMinutes", (Object)this.expiryMinutes()).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("NumberSelectionBehavior", (Object)this.numberSelectionBehaviorAsString()).add("GeoMatchLevel", (Object)this.geoMatchLevelAsString()).add("GeoMatchParams", (Object)this.geoMatchParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "ParticipantPhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.participantPhoneNumbers()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ExpiryMinutes": {
                return Optional.ofNullable(clazz.cast(this.expiryMinutes()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "NumberSelectionBehavior": {
                return Optional.ofNullable(clazz.cast(this.numberSelectionBehaviorAsString()));
            }
            case "GeoMatchLevel": {
                return Optional.ofNullable(clazz.cast(this.geoMatchLevelAsString()));
            }
            case "GeoMatchParams": {
                return Optional.ofNullable(clazz.cast(this.geoMatchParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProxySessionRequest, T> g) {
        return obj -> g.apply((CreateProxySessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private List<String> participantPhoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Integer expiryMinutes;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private String numberSelectionBehavior;
        private String geoMatchLevel;
        private GeoMatchParams geoMatchParams;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxySessionRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.participantPhoneNumbers(model.participantPhoneNumbers);
            this.name(model.name);
            this.expiryMinutes(model.expiryMinutes);
            this.capabilitiesWithStrings(model.capabilities);
            this.numberSelectionBehavior(model.numberSelectionBehavior);
            this.geoMatchLevel(model.geoMatchLevel);
            this.geoMatchParams(model.geoMatchParams);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final Collection<String> getParticipantPhoneNumbers() {
            if (this.participantPhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.participantPhoneNumbers;
        }

        @Override
        public final Builder participantPhoneNumbers(Collection<String> participantPhoneNumbers) {
            this.participantPhoneNumbers = ParticipantPhoneNumberListCopier.copy(participantPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantPhoneNumbers(String ... participantPhoneNumbers) {
            this.participantPhoneNumbers(Arrays.asList(participantPhoneNumbers));
            return this;
        }

        public final void setParticipantPhoneNumbers(Collection<String> participantPhoneNumbers) {
            this.participantPhoneNumbers = ParticipantPhoneNumberListCopier.copy(participantPhoneNumbers);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getExpiryMinutes() {
            return this.expiryMinutes;
        }

        @Override
        public final Builder expiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
            return this;
        }

        public final void setExpiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilityListCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
        }

        public final String getNumberSelectionBehavior() {
            return this.numberSelectionBehavior;
        }

        @Override
        public final Builder numberSelectionBehavior(String numberSelectionBehavior) {
            this.numberSelectionBehavior = numberSelectionBehavior;
            return this;
        }

        @Override
        public final Builder numberSelectionBehavior(NumberSelectionBehavior numberSelectionBehavior) {
            this.numberSelectionBehavior(numberSelectionBehavior == null ? null : numberSelectionBehavior.toString());
            return this;
        }

        public final void setNumberSelectionBehavior(String numberSelectionBehavior) {
            this.numberSelectionBehavior = numberSelectionBehavior;
        }

        public final String getGeoMatchLevel() {
            return this.geoMatchLevel;
        }

        @Override
        public final Builder geoMatchLevel(String geoMatchLevel) {
            this.geoMatchLevel = geoMatchLevel;
            return this;
        }

        @Override
        public final Builder geoMatchLevel(GeoMatchLevel geoMatchLevel) {
            this.geoMatchLevel(geoMatchLevel == null ? null : geoMatchLevel.toString());
            return this;
        }

        public final void setGeoMatchLevel(String geoMatchLevel) {
            this.geoMatchLevel = geoMatchLevel;
        }

        public final GeoMatchParams.Builder getGeoMatchParams() {
            return this.geoMatchParams != null ? this.geoMatchParams.toBuilder() : null;
        }

        @Override
        public final Builder geoMatchParams(GeoMatchParams geoMatchParams) {
            this.geoMatchParams = geoMatchParams;
            return this;
        }

        public final void setGeoMatchParams(GeoMatchParams.BuilderImpl geoMatchParams) {
            this.geoMatchParams = geoMatchParams != null ? geoMatchParams.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxySessionRequest build() {
            return new CreateProxySessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProxySessionRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder participantPhoneNumbers(Collection<String> var1);

        public Builder participantPhoneNumbers(String ... var1);

        public Builder name(String var1);

        public Builder expiryMinutes(Integer var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder numberSelectionBehavior(String var1);

        public Builder numberSelectionBehavior(NumberSelectionBehavior var1);

        public Builder geoMatchLevel(String var1);

        public Builder geoMatchLevel(GeoMatchLevel var1);

        public Builder geoMatchParams(GeoMatchParams var1);

        default public Builder geoMatchParams(Consumer<GeoMatchParams.Builder> geoMatchParams) {
            return this.geoMatchParams((GeoMatchParams)((GeoMatchParams.Builder)GeoMatchParams.builder().applyMutation(geoMatchParams)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

