/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StorageClass {
    WARM("WARM"),
    COLD("COLD"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StorageClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StorageClass.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StorageClass> knownValues() {
        return Stream.of(StorageClass.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

