/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.internal.AbstractAwsSigner;
import software.amazon.awssdk.auth.signer.internal.AwsSignerExecutionAttribute;
import software.amazon.awssdk.auth.signer.internal.SigningAlgorithm;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.StringUtils;

@Deprecated
@SdkProtectedApi
public final class QueryStringSigner
extends AbstractAwsSigner {
    private final Date overriddenDate;

    private QueryStringSigner(Builder builder) {
        this.overriddenDate = builder.overriddenDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryStringSigner create() {
        return QueryStringSigner.builder().build();
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        AwsCredentials awsCredentials = (AwsCredentials)executionAttributes.getAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS);
        Integer offset = (Integer)executionAttributes.getAttribute(AwsSignerExecutionAttribute.TIME_OFFSET);
        if (CredentialUtils.isAnonymous(awsCredentials)) {
            return request;
        }
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
        AwsCredentials sanitizedCredentials = this.sanitizeCredentials(awsCredentials);
        mutableRequest.putRawQueryParameter("AWSAccessKeyId", sanitizedCredentials.accessKeyId());
        mutableRequest.putRawQueryParameter("SignatureVersion", "2");
        int timeOffset = offset == null ? 0 : offset;
        mutableRequest.putRawQueryParameter("Timestamp", this.getFormattedTimestamp(timeOffset));
        if (sanitizedCredentials instanceof AwsSessionCredentials) {
            this.addSessionCredentials(mutableRequest, (AwsSessionCredentials)sanitizedCredentials);
        }
        mutableRequest.putRawQueryParameter("SignatureMethod", SigningAlgorithm.HmacSHA256.toString());
        String stringToSign = this.calculateStringToSignV2(mutableRequest);
        String signatureValue = this.signAndBase64Encode(stringToSign, sanitizedCredentials.secretAccessKey(), SigningAlgorithm.HmacSHA256);
        mutableRequest.putRawQueryParameter("Signature", signatureValue);
        return (SdkHttpFullRequest)mutableRequest.build();
    }

    private String calculateStringToSignV2(SdkHttpFullRequest.Builder requestBuilder) throws SdkClientException {
        SdkHttpFullRequest request = (SdkHttpFullRequest)requestBuilder.build();
        return "POST\n" + this.getCanonicalizedEndpoint(request) + "\n" + this.getCanonicalizedResourcePath(request) + "\n" + this.getCanonicalizedQueryString(request.rawQueryParameters());
    }

    private String getCanonicalizedResourcePath(SdkHttpFullRequest request) {
        return StringUtils.isEmpty((CharSequence)request.encodedPath()) ? "/" : request.encodedPath();
    }

    private String getFormattedTimestamp(int offset) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.overriddenDate != null) {
            return df.format(this.overriddenDate);
        }
        return df.format(this.getSignatureDate(offset));
    }

    private Date getSignatureDate(int offsetInSeconds) {
        return Date.from(Instant.now().minusSeconds(offsetInSeconds));
    }

    @Override
    protected void addSessionCredentials(SdkHttpFullRequest.Builder request, AwsSessionCredentials credentials) {
        request.putRawQueryParameter("SecurityToken", credentials.sessionToken());
    }

    public static final class Builder {
        private Date overriddenDate;

        Builder overriddenDate(Date overriddenDate) {
            this.overriddenDate = overriddenDate;
            return this;
        }

        public QueryStringSigner build() {
            return new QueryStringSigner(this);
        }
    }
}

