/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse;

public class ListAssessmentFrameworksPublisher
implements SdkPublisher<ListAssessmentFrameworksResponse> {
    private final AuditManagerAsyncClient client;
    private final ListAssessmentFrameworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssessmentFrameworksPublisher(AuditManagerAsyncClient client, ListAssessmentFrameworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssessmentFrameworksPublisher(AuditManagerAsyncClient client, ListAssessmentFrameworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssessmentFrameworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssessmentFrameworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssessmentFrameworksResponseFetcher
    implements AsyncPageFetcher<ListAssessmentFrameworksResponse> {
        private ListAssessmentFrameworksResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentFrameworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssessmentFrameworksResponse> nextPage(ListAssessmentFrameworksResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentFrameworksPublisher.this.client.listAssessmentFrameworks(ListAssessmentFrameworksPublisher.this.firstRequest);
            }
            return ListAssessmentFrameworksPublisher.this.client.listAssessmentFrameworks((ListAssessmentFrameworksRequest)((Object)ListAssessmentFrameworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

