/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SettingAttribute {
    ALL("ALL"),
    IS_AWS_ORG_ENABLED("IS_AWS_ORG_ENABLED"),
    SNS_TOPIC("SNS_TOPIC"),
    DEFAULT_ASSESSMENT_REPORTS_DESTINATION("DEFAULT_ASSESSMENT_REPORTS_DESTINATION"),
    DEFAULT_PROCESS_OWNERS("DEFAULT_PROCESS_OWNERS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SettingAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SettingAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SettingAttribute.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SettingAttribute> knownValues() {
        return Stream.of(SettingAttribute.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

