/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.auditmanager.model.EvidenceAttributesCopier;
import software.amazon.awssdk.services.auditmanager.model.Resource;
import software.amazon.awssdk.services.auditmanager.model.ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Evidence
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Evidence> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSource").getter(Evidence.getter(Evidence::dataSource)).setter(Evidence.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<String> EVIDENCE_AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evidenceAwsAccountId").getter(Evidence.getter(Evidence::evidenceAwsAccountId)).setter(Evidence.setter(Builder::evidenceAwsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceAwsAccountId").build()}).build();
    private static final SdkField<Instant> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("time").getter(Evidence.getter(Evidence::time)).setter(Evidence.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventSource").getter(Evidence.getter(Evidence::eventSource)).setter(Evidence.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSource").build()}).build();
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventName").getter(Evidence.getter(Evidence::eventName)).setter(Evidence.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventName").build()}).build();
    private static final SdkField<String> EVIDENCE_BY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evidenceByType").getter(Evidence.getter(Evidence::evidenceByType)).setter(Evidence.setter(Builder::evidenceByType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceByType").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_INCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourcesIncluded").getter(Evidence.getter(Evidence::resourcesIncluded)).setter(Evidence.setter(Builder::resourcesIncluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesIncluded").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(Evidence.getter(Evidence::attributes)).setter(Evidence.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamId").getter(Evidence.getter(Evidence::iamId)).setter(Evidence.setter(Builder::iamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamId").build()}).build();
    private static final SdkField<String> COMPLIANCE_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceCheck").getter(Evidence.getter(Evidence::complianceCheck)).setter(Evidence.setter(Builder::complianceCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceCheck").build()}).build();
    private static final SdkField<String> AWS_ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsOrganization").getter(Evidence.getter(Evidence::awsOrganization)).setter(Evidence.setter(Builder::awsOrganization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsOrganization").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(Evidence.getter(Evidence::awsAccountId)).setter(Evidence.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> EVIDENCE_FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evidenceFolderId").getter(Evidence.getter(Evidence::evidenceFolderId)).setter(Evidence.setter(Builder::evidenceFolderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFolderId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Evidence.getter(Evidence::id)).setter(Evidence.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ASSESSMENT_REPORT_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentReportSelection").getter(Evidence.getter(Evidence::assessmentReportSelection)).setter(Evidence.setter(Builder::assessmentReportSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, EVIDENCE_AWS_ACCOUNT_ID_FIELD, TIME_FIELD, EVENT_SOURCE_FIELD, EVENT_NAME_FIELD, EVIDENCE_BY_TYPE_FIELD, RESOURCES_INCLUDED_FIELD, ATTRIBUTES_FIELD, IAM_ID_FIELD, COMPLIANCE_CHECK_FIELD, AWS_ORGANIZATION_FIELD, AWS_ACCOUNT_ID_FIELD, EVIDENCE_FOLDER_ID_FIELD, ID_FIELD, ASSESSMENT_REPORT_SELECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSource;
    private final String evidenceAwsAccountId;
    private final Instant time;
    private final String eventSource;
    private final String eventName;
    private final String evidenceByType;
    private final List<Resource> resourcesIncluded;
    private final Map<String, String> attributes;
    private final String iamId;
    private final String complianceCheck;
    private final String awsOrganization;
    private final String awsAccountId;
    private final String evidenceFolderId;
    private final String id;
    private final String assessmentReportSelection;

    private Evidence(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.evidenceAwsAccountId = builder.evidenceAwsAccountId;
        this.time = builder.time;
        this.eventSource = builder.eventSource;
        this.eventName = builder.eventName;
        this.evidenceByType = builder.evidenceByType;
        this.resourcesIncluded = builder.resourcesIncluded;
        this.attributes = builder.attributes;
        this.iamId = builder.iamId;
        this.complianceCheck = builder.complianceCheck;
        this.awsOrganization = builder.awsOrganization;
        this.awsAccountId = builder.awsAccountId;
        this.evidenceFolderId = builder.evidenceFolderId;
        this.id = builder.id;
        this.assessmentReportSelection = builder.assessmentReportSelection;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final String evidenceAwsAccountId() {
        return this.evidenceAwsAccountId;
    }

    public final Instant time() {
        return this.time;
    }

    public final String eventSource() {
        return this.eventSource;
    }

    public final String eventName() {
        return this.eventName;
    }

    public final String evidenceByType() {
        return this.evidenceByType;
    }

    public final boolean hasResourcesIncluded() {
        return this.resourcesIncluded != null && !(this.resourcesIncluded instanceof SdkAutoConstructList);
    }

    public final List<Resource> resourcesIncluded() {
        return this.resourcesIncluded;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String iamId() {
        return this.iamId;
    }

    public final String complianceCheck() {
        return this.complianceCheck;
    }

    public final String awsOrganization() {
        return this.awsOrganization;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String evidenceFolderId() {
        return this.evidenceFolderId;
    }

    public final String id() {
        return this.id;
    }

    public final String assessmentReportSelection() {
        return this.assessmentReportSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceByType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesIncluded() ? this.resourcesIncluded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsOrganization());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentReportSelection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evidence)) {
            return false;
        }
        Evidence other = (Evidence)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.evidenceAwsAccountId(), other.evidenceAwsAccountId()) && Objects.equals(this.time(), other.time()) && Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.eventName(), other.eventName()) && Objects.equals(this.evidenceByType(), other.evidenceByType()) && this.hasResourcesIncluded() == other.hasResourcesIncluded() && Objects.equals(this.resourcesIncluded(), other.resourcesIncluded()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.iamId(), other.iamId()) && Objects.equals(this.complianceCheck(), other.complianceCheck()) && Objects.equals(this.awsOrganization(), other.awsOrganization()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.evidenceFolderId(), other.evidenceFolderId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.assessmentReportSelection(), other.assessmentReportSelection());
    }

    public final String toString() {
        return ToString.builder((String)"Evidence").add("DataSource", (Object)this.dataSource()).add("EvidenceAwsAccountId", (Object)this.evidenceAwsAccountId()).add("Time", (Object)this.time()).add("EventSource", (Object)this.eventSource()).add("EventName", (Object)this.eventName()).add("EvidenceByType", (Object)this.evidenceByType()).add("ResourcesIncluded", this.hasResourcesIncluded() ? this.resourcesIncluded() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("IamId", (Object)this.iamId()).add("ComplianceCheck", (Object)this.complianceCheck()).add("AwsOrganization", (Object)this.awsOrganization()).add("AwsAccountId", (Object)this.awsAccountId()).add("EvidenceFolderId", (Object)this.evidenceFolderId()).add("Id", (Object)this.id()).add("AssessmentReportSelection", (Object)this.assessmentReportSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "evidenceAwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.evidenceAwsAccountId()));
            }
            case "time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "eventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "eventName": {
                return Optional.ofNullable(clazz.cast(this.eventName()));
            }
            case "evidenceByType": {
                return Optional.ofNullable(clazz.cast(this.evidenceByType()));
            }
            case "resourcesIncluded": {
                return Optional.ofNullable(clazz.cast(this.resourcesIncluded()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "iamId": {
                return Optional.ofNullable(clazz.cast(this.iamId()));
            }
            case "complianceCheck": {
                return Optional.ofNullable(clazz.cast(this.complianceCheck()));
            }
            case "awsOrganization": {
                return Optional.ofNullable(clazz.cast(this.awsOrganization()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "evidenceFolderId": {
                return Optional.ofNullable(clazz.cast(this.evidenceFolderId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "assessmentReportSelection": {
                return Optional.ofNullable(clazz.cast(this.assessmentReportSelection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Evidence, T> g) {
        return obj -> g.apply((Evidence)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSource;
        private String evidenceAwsAccountId;
        private Instant time;
        private String eventSource;
        private String eventName;
        private String evidenceByType;
        private List<Resource> resourcesIncluded = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String iamId;
        private String complianceCheck;
        private String awsOrganization;
        private String awsAccountId;
        private String evidenceFolderId;
        private String id;
        private String assessmentReportSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(Evidence model) {
            this.dataSource(model.dataSource);
            this.evidenceAwsAccountId(model.evidenceAwsAccountId);
            this.time(model.time);
            this.eventSource(model.eventSource);
            this.eventName(model.eventName);
            this.evidenceByType(model.evidenceByType);
            this.resourcesIncluded(model.resourcesIncluded);
            this.attributes(model.attributes);
            this.iamId(model.iamId);
            this.complianceCheck(model.complianceCheck);
            this.awsOrganization(model.awsOrganization);
            this.awsAccountId(model.awsAccountId);
            this.evidenceFolderId(model.evidenceFolderId);
            this.id(model.id);
            this.assessmentReportSelection(model.assessmentReportSelection);
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getEvidenceAwsAccountId() {
            return this.evidenceAwsAccountId;
        }

        @Override
        public final Builder evidenceAwsAccountId(String evidenceAwsAccountId) {
            this.evidenceAwsAccountId = evidenceAwsAccountId;
            return this;
        }

        public final void setEvidenceAwsAccountId(String evidenceAwsAccountId) {
            this.evidenceAwsAccountId = evidenceAwsAccountId;
        }

        public final Instant getTime() {
            return this.time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getEventName() {
            return this.eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public final String getEvidenceByType() {
            return this.evidenceByType;
        }

        @Override
        public final Builder evidenceByType(String evidenceByType) {
            this.evidenceByType = evidenceByType;
            return this;
        }

        public final void setEvidenceByType(String evidenceByType) {
            this.evidenceByType = evidenceByType;
        }

        public final List<Resource.Builder> getResourcesIncluded() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.resourcesIncluded);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resourcesIncluded(Collection<Resource> resourcesIncluded) {
            this.resourcesIncluded = ResourcesCopier.copy(resourcesIncluded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesIncluded(Resource ... resourcesIncluded) {
            this.resourcesIncluded(Arrays.asList(resourcesIncluded));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesIncluded(Consumer<Resource.Builder> ... resourcesIncluded) {
            this.resourcesIncluded(Stream.of(resourcesIncluded).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourcesIncluded(Collection<Resource.BuilderImpl> resourcesIncluded) {
            this.resourcesIncluded = ResourcesCopier.copyFromBuilder(resourcesIncluded);
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = EvidenceAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = EvidenceAttributesCopier.copy(attributes);
        }

        public final String getIamId() {
            return this.iamId;
        }

        @Override
        public final Builder iamId(String iamId) {
            this.iamId = iamId;
            return this;
        }

        public final void setIamId(String iamId) {
            this.iamId = iamId;
        }

        public final String getComplianceCheck() {
            return this.complianceCheck;
        }

        @Override
        public final Builder complianceCheck(String complianceCheck) {
            this.complianceCheck = complianceCheck;
            return this;
        }

        public final void setComplianceCheck(String complianceCheck) {
            this.complianceCheck = complianceCheck;
        }

        public final String getAwsOrganization() {
            return this.awsOrganization;
        }

        @Override
        public final Builder awsOrganization(String awsOrganization) {
            this.awsOrganization = awsOrganization;
            return this;
        }

        public final void setAwsOrganization(String awsOrganization) {
            this.awsOrganization = awsOrganization;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getEvidenceFolderId() {
            return this.evidenceFolderId;
        }

        @Override
        public final Builder evidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
            return this;
        }

        public final void setEvidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getAssessmentReportSelection() {
            return this.assessmentReportSelection;
        }

        @Override
        public final Builder assessmentReportSelection(String assessmentReportSelection) {
            this.assessmentReportSelection = assessmentReportSelection;
            return this;
        }

        public final void setAssessmentReportSelection(String assessmentReportSelection) {
            this.assessmentReportSelection = assessmentReportSelection;
        }

        public Evidence build() {
            return new Evidence(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Evidence> {
        public Builder dataSource(String var1);

        public Builder evidenceAwsAccountId(String var1);

        public Builder time(Instant var1);

        public Builder eventSource(String var1);

        public Builder eventName(String var1);

        public Builder evidenceByType(String var1);

        public Builder resourcesIncluded(Collection<Resource> var1);

        public Builder resourcesIncluded(Resource ... var1);

        public Builder resourcesIncluded(Consumer<Resource.Builder> ... var1);

        public Builder attributes(Map<String, String> var1);

        public Builder iamId(String var1);

        public Builder complianceCheck(String var1);

        public Builder awsOrganization(String var1);

        public Builder awsAccountId(String var1);

        public Builder evidenceFolderId(String var1);

        public Builder id(String var1);

        public Builder assessmentReportSelection(String var1);
    }
}

