/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError;
import software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentErrorsCopier;
import software.amazon.awssdk.services.auditmanager.model.Delegation;
import software.amazon.awssdk.services.auditmanager.model.DelegationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateDelegationByAssessmentResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, BatchCreateDelegationByAssessmentResponse> {
    private static final SdkField<List<Delegation>> DELEGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("delegations").getter(BatchCreateDelegationByAssessmentResponse.getter(BatchCreateDelegationByAssessmentResponse::delegations)).setter(BatchCreateDelegationByAssessmentResponse.setter(Builder::delegations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Delegation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchCreateDelegationByAssessmentError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchCreateDelegationByAssessmentResponse.getter(BatchCreateDelegationByAssessmentResponse::errors)).setter(BatchCreateDelegationByAssessmentResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateDelegationByAssessmentError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATIONS_FIELD, ERRORS_FIELD));
    private final List<Delegation> delegations;
    private final List<BatchCreateDelegationByAssessmentError> errors;

    private BatchCreateDelegationByAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.delegations = builder.delegations;
        this.errors = builder.errors;
    }

    public final boolean hasDelegations() {
        return this.delegations != null && !(this.delegations instanceof SdkAutoConstructList);
    }

    public final List<Delegation> delegations() {
        return this.delegations;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateDelegationByAssessmentError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDelegations() ? this.delegations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateDelegationByAssessmentResponse)) {
            return false;
        }
        BatchCreateDelegationByAssessmentResponse other = (BatchCreateDelegationByAssessmentResponse)((Object)obj);
        return this.hasDelegations() == other.hasDelegations() && Objects.equals(this.delegations(), other.delegations()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateDelegationByAssessmentResponse").add("Delegations", this.hasDelegations() ? this.delegations() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "delegations": {
                return Optional.ofNullable(clazz.cast(this.delegations()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateDelegationByAssessmentResponse, T> g) {
        return obj -> g.apply((BatchCreateDelegationByAssessmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<Delegation> delegations = DefaultSdkAutoConstructList.getInstance();
        private List<BatchCreateDelegationByAssessmentError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateDelegationByAssessmentResponse model) {
            super(model);
            this.delegations(model.delegations);
            this.errors(model.errors);
        }

        public final List<Delegation.Builder> getDelegations() {
            List<Delegation.Builder> result = DelegationsCopier.copyToBuilder(this.delegations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder delegations(Collection<Delegation> delegations) {
            this.delegations = DelegationsCopier.copy(delegations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Delegation ... delegations) {
            this.delegations(Arrays.asList(delegations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Consumer<Delegation.Builder> ... delegations) {
            this.delegations(Stream.of(delegations).map(c -> (Delegation)((Delegation.Builder)Delegation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDelegations(Collection<Delegation.BuilderImpl> delegations) {
            this.delegations = DelegationsCopier.copyFromBuilder(delegations);
        }

        public final List<BatchCreateDelegationByAssessmentError.Builder> getErrors() {
            List<BatchCreateDelegationByAssessmentError.Builder> result = BatchCreateDelegationByAssessmentErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<BatchCreateDelegationByAssessmentError> errors) {
            this.errors = BatchCreateDelegationByAssessmentErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchCreateDelegationByAssessmentError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchCreateDelegationByAssessmentError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchCreateDelegationByAssessmentError)((BatchCreateDelegationByAssessmentError.Builder)BatchCreateDelegationByAssessmentError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchCreateDelegationByAssessmentError.BuilderImpl> errors) {
            this.errors = BatchCreateDelegationByAssessmentErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchCreateDelegationByAssessmentResponse build() {
            return new BatchCreateDelegationByAssessmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateDelegationByAssessmentResponse> {
        public Builder delegations(Collection<Delegation> var1);

        public Builder delegations(Delegation ... var1);

        public Builder delegations(Consumer<Delegation.Builder> ... var1);

        public Builder errors(Collection<BatchCreateDelegationByAssessmentError> var1);

        public Builder errors(BatchCreateDelegationByAssessmentError ... var1);

        public Builder errors(Consumer<BatchCreateDelegationByAssessmentError.Builder> ... var1);
    }
}

