/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsClient;
import software.amazon.awssdk.services.applicationinsights.model.ListProblemsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListProblemsResponse;

public class ListProblemsIterable
implements SdkIterable<ListProblemsResponse> {
    private final ApplicationInsightsClient client;
    private final ListProblemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProblemsIterable(ApplicationInsightsClient client, ListProblemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProblemsResponseFetcher();
    }

    public Iterator<ListProblemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProblemsResponseFetcher
    implements SyncPageFetcher<ListProblemsResponse> {
        private ListProblemsResponseFetcher() {
        }

        public boolean hasNextPage(ListProblemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProblemsResponse nextPage(ListProblemsResponse previousPage) {
            if (previousPage == null) {
                return ListProblemsIterable.this.client.listProblems(ListProblemsIterable.this.firstRequest);
            }
            return ListProblemsIterable.this.client.listProblems((ListProblemsRequest)((Object)ListProblemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

