/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.LogPatternSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLogPatternSetsResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, ListLogPatternSetsResponse> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(ListLogPatternSetsResponse.getter(ListLogPatternSetsResponse::resourceGroupName)).setter(ListLogPatternSetsResponse.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<List<String>> LOG_PATTERN_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogPatternSets").getter(ListLogPatternSetsResponse.getter(ListLogPatternSetsResponse::logPatternSets)).setter(ListLogPatternSetsResponse.setter(Builder::logPatternSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPatternSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLogPatternSetsResponse.getter(ListLogPatternSetsResponse::nextToken)).setter(ListLogPatternSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, LOG_PATTERN_SETS_FIELD, NEXT_TOKEN_FIELD));
    private final String resourceGroupName;
    private final List<String> logPatternSets;
    private final String nextToken;

    private ListLogPatternSetsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.logPatternSets = builder.logPatternSets;
        this.nextToken = builder.nextToken;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final boolean hasLogPatternSets() {
        return this.logPatternSets != null && !(this.logPatternSets instanceof SdkAutoConstructList);
    }

    public final List<String> logPatternSets() {
        return this.logPatternSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogPatternSets() ? this.logPatternSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogPatternSetsResponse)) {
            return false;
        }
        ListLogPatternSetsResponse other = (ListLogPatternSetsResponse)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && this.hasLogPatternSets() == other.hasLogPatternSets() && Objects.equals(this.logPatternSets(), other.logPatternSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLogPatternSetsResponse").add("ResourceGroupName", (Object)this.resourceGroupName()).add("LogPatternSets", this.hasLogPatternSets() ? this.logPatternSets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "LogPatternSets": {
                return Optional.ofNullable(clazz.cast(this.logPatternSets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogPatternSetsResponse, T> g) {
        return obj -> g.apply((ListLogPatternSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private List<String> logPatternSets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogPatternSetsResponse model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.logPatternSets(model.logPatternSets);
            this.nextToken(model.nextToken);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final Collection<String> getLogPatternSets() {
            if (this.logPatternSets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logPatternSets;
        }

        @Override
        public final Builder logPatternSets(Collection<String> logPatternSets) {
            this.logPatternSets = LogPatternSetListCopier.copy(logPatternSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPatternSets(String ... logPatternSets) {
            this.logPatternSets(Arrays.asList(logPatternSets));
            return this;
        }

        public final void setLogPatternSets(Collection<String> logPatternSets) {
            this.logPatternSets = LogPatternSetListCopier.copy(logPatternSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLogPatternSetsResponse build() {
            return new ListLogPatternSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLogPatternSetsResponse> {
        public Builder resourceGroupName(String var1);

        public Builder logPatternSets(Collection<String> var1);

        public Builder logPatternSets(String ... var1);

        public Builder nextToken(String var1);
    }
}

