/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingClient;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction;

public class DescribeScheduledActionsIterable
implements SdkIterable<DescribeScheduledActionsResponse> {
    private final ApplicationAutoScalingClient client;
    private final DescribeScheduledActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScheduledActionsIterable(ApplicationAutoScalingClient client, DescribeScheduledActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScheduledActionsResponseFetcher();
    }

    public Iterator<DescribeScheduledActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduledAction> scheduledActions() {
        Function<DescribeScheduledActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledActions() != null) {
                return response.scheduledActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeScheduledActionsResponseFetcher
    implements SyncPageFetcher<DescribeScheduledActionsResponse> {
        private DescribeScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeScheduledActionsResponse nextPage(DescribeScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledActionsIterable.this.client.describeScheduledActions(DescribeScheduledActionsIterable.this.firstRequest);
            }
            return DescribeScheduledActionsIterable.this.client.describeScheduledActions((DescribeScheduledActionsRequest)((Object)DescribeScheduledActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

