/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.S3OutputFormatConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DestinationProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DestinationProperties> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(S3DestinationProperties.getter(S3DestinationProperties::bucketName)).setter(S3DestinationProperties.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketPrefix").getter(S3DestinationProperties.getter(S3DestinationProperties::bucketPrefix)).setter(S3DestinationProperties.setter(Builder::bucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()}).build();
    private static final SdkField<S3OutputFormatConfig> S3_OUTPUT_FORMAT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3OutputFormatConfig").getter(S3DestinationProperties.getter(S3DestinationProperties::s3OutputFormatConfig)).setter(S3DestinationProperties.setter(Builder::s3OutputFormatConfig)).constructor(S3OutputFormatConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputFormatConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, S3_OUTPUT_FORMAT_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String bucketPrefix;
    private final S3OutputFormatConfig s3OutputFormatConfig;

    private S3DestinationProperties(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.s3OutputFormatConfig = builder.s3OutputFormatConfig;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String bucketPrefix() {
        return this.bucketPrefix;
    }

    public final S3OutputFormatConfig s3OutputFormatConfig() {
        return this.s3OutputFormatConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputFormatConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationProperties)) {
            return false;
        }
        S3DestinationProperties other = (S3DestinationProperties)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.bucketPrefix(), other.bucketPrefix()) && Objects.equals(this.s3OutputFormatConfig(), other.s3OutputFormatConfig());
    }

    public final String toString() {
        return ToString.builder((String)"S3DestinationProperties").add("BucketName", (Object)this.bucketName()).add("BucketPrefix", (Object)this.bucketPrefix()).add("S3OutputFormatConfig", (Object)this.s3OutputFormatConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "bucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.bucketPrefix()));
            }
            case "s3OutputFormatConfig": {
                return Optional.ofNullable(clazz.cast(this.s3OutputFormatConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationProperties, T> g) {
        return obj -> g.apply((S3DestinationProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String bucketPrefix;
        private S3OutputFormatConfig s3OutputFormatConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationProperties model) {
            this.bucketName(model.bucketName);
            this.bucketPrefix(model.bucketPrefix);
            this.s3OutputFormatConfig(model.s3OutputFormatConfig);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getBucketPrefix() {
            return this.bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        public final S3OutputFormatConfig.Builder getS3OutputFormatConfig() {
            return this.s3OutputFormatConfig != null ? this.s3OutputFormatConfig.toBuilder() : null;
        }

        @Override
        public final Builder s3OutputFormatConfig(S3OutputFormatConfig s3OutputFormatConfig) {
            this.s3OutputFormatConfig = s3OutputFormatConfig;
            return this;
        }

        public final void setS3OutputFormatConfig(S3OutputFormatConfig.BuilderImpl s3OutputFormatConfig) {
            this.s3OutputFormatConfig = s3OutputFormatConfig != null ? s3OutputFormatConfig.build() : null;
        }

        public S3DestinationProperties build() {
            return new S3DestinationProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DestinationProperties> {
        public Builder bucketName(String var1);

        public Builder bucketPrefix(String var1);

        public Builder s3OutputFormatConfig(S3OutputFormatConfig var1);

        default public Builder s3OutputFormatConfig(Consumer<S3OutputFormatConfig.Builder> s3OutputFormatConfig) {
            return this.s3OutputFormatConfig((S3OutputFormatConfig)((S3OutputFormatConfig.Builder)S3OutputFormatConfig.builder().applyMutation(s3OutputFormatConfig)).build());
        }
    }
}

