/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConnectorType {
    SALESFORCE("Salesforce"),
    SINGULAR("Singular"),
    SLACK("Slack"),
    REDSHIFT("Redshift"),
    S3("S3"),
    MARKETO("Marketo"),
    GOOGLEANALYTICS("Googleanalytics"),
    ZENDESK("Zendesk"),
    SERVICENOW("Servicenow"),
    DATADOG("Datadog"),
    TRENDMICRO("Trendmicro"),
    SNOWFLAKE("Snowflake"),
    DYNATRACE("Dynatrace"),
    INFORNEXUS("Infornexus"),
    AMPLITUDE("Amplitude"),
    VEEVA("Veeva"),
    EVENT_BRIDGE("EventBridge"),
    LOOKOUT_METRICS("LookoutMetrics"),
    UPSOLVER("Upsolver"),
    HONEYCODE("Honeycode"),
    CUSTOMER_PROFILES("CustomerProfiles"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConnectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConnectorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorType> knownValues() {
        return Stream.of(ConnectorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

