/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ValidatorType {
    JSON_SCHEMA("JSON_SCHEMA"),
    LAMBDA("LAMBDA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ValidatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ValidatorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidatorType> knownValues() {
        return Stream.of(ValidatorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

