/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentEventType {
    PERCENTAGE_UPDATED("PERCENTAGE_UPDATED"),
    ROLLBACK_STARTED("ROLLBACK_STARTED"),
    ROLLBACK_COMPLETED("ROLLBACK_COMPLETED"),
    BAKE_TIME_STARTED("BAKE_TIME_STARTED"),
    DEPLOYMENT_STARTED("DEPLOYMENT_STARTED"),
    DEPLOYMENT_COMPLETED("DEPLOYMENT_COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentEventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentEventType> knownValues() {
        return Stream.of(DeploymentEventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

