/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResolutionStrategy {
    OPTIMISTIC_CONCURRENCY("OPTIMISTIC_CONCURRENCY"),
    LAMBDA("LAMBDA"),
    AUTOMERGE("AUTOMERGE"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResolutionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResolutionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResolutionStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResolutionStrategy> knownValues() {
        return Stream.of(ResolutionStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

