/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReasonCode {
    AWS_SERVICE_ACCESS_DISABLED("AWS_SERVICE_ACCESS_DISABLED"),
    DELEGATED_ADMINISTRATOR_DEREGISTERED("DELEGATED_ADMINISTRATOR_DEREGISTERED"),
    ORGANIZATION_DELETED("ORGANIZATION_DELETED"),
    SERVICE_LINKED_ROLE_CREATION_FAILED("SERVICE_LINKED_ROLE_CREATION_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReasonCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReasonCode> knownValues() {
        return Stream.of(ReasonCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

